/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.shapes;

import com.gildedgames.orbis.lib.data.region.IMutableRegion;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractShape
implements IShape {
    private boolean createFromCenter;
    private boolean uniform;
    private World world;
    private IMutableRegion boundingBox;

    public AbstractShape() {
    }

    protected AbstractShape(World world) {
        this.world = world;
    }

    public AbstractShape(IMutableRegion boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setCreateFromCenter(boolean flag) {
        this.createFromCenter = flag;
    }

    public boolean createFromCenter() {
        return this.createFromCenter;
    }

    public boolean isUniform() {
        return this.uniform;
    }

    public void setUniform(boolean flag) {
        this.uniform = flag;
    }

    public IMutableRegion getMutableBB() {
        return this.boundingBox;
    }

    @Override
    public final Iterable<BlockPos.MutableBlockPos> createShapeData() {
        return new Iterable<BlockPos.MutableBlockPos>(){

            @Override
            public Iterator<BlockPos.MutableBlockPos> iterator() {
                final Iterator<BlockPos.MutableBlockPos> iter = AbstractShape.this.getBoundingBox().createShapeData().iterator();
                return new AbstractIterator<BlockPos.MutableBlockPos>(){

                    protected BlockPos.MutableBlockPos computeNext() {
                        while (iter.hasNext()) {
                            BlockPos.MutableBlockPos next = (BlockPos.MutableBlockPos)iter.next();
                            if (!AbstractShape.this.contains(next.func_177958_n(), next.func_177956_o(), next.func_177952_p())) continue;
                            return next;
                        }
                        return (BlockPos.MutableBlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public IRegion getBoundingBox() {
        return this.boundingBox;
    }

    protected void setBoundingBox(IMutableRegion bb) {
        this.boundingBox = bb;
    }

    @Override
    public final void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74757_a("createFromCenter", this.createFromCenter);
        tag.func_74757_a("uniform", this.uniform);
        funnel.set("boundingBox", this.boundingBox);
        this.writeShape(tag);
    }

    public abstract void writeShape(NBTTagCompound var1);

    @Override
    public final void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.createFromCenter = tag.func_74767_n("createFromCenter");
        this.uniform = tag.func_74767_n("uniform");
        this.boundingBox = (IMutableRegion)funnel.get("boundingBox");
        this.readShape(tag);
    }

    public abstract void readShape(NBTTagCompound var1);

    public abstract BlockPos getRenderBoxMin();

    public abstract BlockPos getRenderBoxMax();
}

