/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.shapes;

import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.shapes.AbstractShape;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CuboidOutskirtShape
extends AbstractShape {
    private BlockPos start;
    private BlockPos end;
    private boolean centered;
    private Iterable<BlockPos.MutableBlockPos> data;
    private BlockPos renderMin;
    private BlockPos renderMax;

    private CuboidOutskirtShape(World world) {
        super(world);
    }

    public CuboidOutskirtShape(BlockPos start, BlockPos end, boolean centered) {
        this.start = start;
        this.end = end;
        int radius = (int)Math.sqrt(this.start.func_177951_i((Vec3i)this.end));
        this.setBoundingBox(centered ? new Region(new BlockPos(-radius, -radius, -radius).func_177971_a((Vec3i)this.start), new BlockPos(radius, radius, radius).func_177971_a((Vec3i)this.start)) : new Region(start, end));
        this.centered = centered;
        this.renderMin = this.getBoundingBox().getMin();
        this.renderMax = this.getBoundingBox().getMax();
    }

    @Override
    public BlockPos getRenderBoxMin() {
        return this.getBoundingBox().getMin();
    }

    @Override
    public BlockPos getRenderBoxMax() {
        return this.getBoundingBox().getMax();
    }

    @Override
    public void writeShape(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setPos("viableStarts", this.start);
        funnel.setPos("end", this.end);
        tag.func_74757_a("centered", this.centered);
    }

    @Override
    public void readShape(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.start = funnel.getPos("viableStarts");
        this.end = funnel.getPos("end");
        this.centered = tag.func_74767_n("centered");
    }

    @Override
    public IShape rotate(Rotation rotation, IRegion in) {
        return this;
    }

    @Override
    public IShape translate(int x, int y, int z) {
        return new CuboidOutskirtShape(this.start.func_177982_a(x, y, z), this.end.func_177982_a(x, y, z), this.centered);
    }

    @Override
    public IShape translate(BlockPos pos) {
        return this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (this.createFromCenter() || !this.isUniform()) {
            boolean north = x == this.getBoundingBox().getMin().func_177958_n();
            boolean south = x == this.getBoundingBox().getMax().func_177958_n();
            boolean east = z == this.getBoundingBox().getMax().func_177952_p();
            boolean west = z == this.getBoundingBox().getMin().func_177952_p();
            boolean up = y == this.getBoundingBox().getMax().func_177956_o();
            boolean down = y == this.getBoundingBox().getMin().func_177956_o();
            return RegionHelp.contains(this.getBoundingBox(), (float)x, (float)y, (float)z) && (north || south || east || west || up || down);
        }
        int minSize = Math.min(this.getBoundingBox().getWidth(), this.getBoundingBox().getLength());
        int xDif = Math.abs(x - this.start.func_177958_n());
        int zDif = Math.abs(z - this.start.func_177952_p());
        return RegionHelp.contains(this.getBoundingBox(), (float)x, (float)y, (float)z) && xDif < minSize && zDif < minSize && xDif + 1 >= minSize && zDif + 1 >= minSize;
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> getShapeData() {
        if (this.data == null) {
            this.data = this.createShapeData();
        }
        return this.data;
    }
}

