/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.shapes;

import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.shapes.AbstractShape;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CylinderShape
extends AbstractShape {
    private BlockPos start;
    private BlockPos end;
    private boolean centered;
    private Iterable<BlockPos.MutableBlockPos> data;
    private BlockPos renderMin;
    private BlockPos renderMax;

    private CylinderShape(World world) {
        super(world);
    }

    public CylinderShape(BlockPos start, BlockPos end, boolean centered) {
        this.start = start;
        this.end = end;
        int radius = (int)Math.sqrt(this.start.func_177951_i((Vec3i)this.end));
        this.setBoundingBox(centered ? new Region(new BlockPos(-radius, -radius, -radius).func_177971_a((Vec3i)this.start), new BlockPos(radius, radius, radius).func_177971_a((Vec3i)this.start)) : new Region(start, new BlockPos(end.func_177958_n(), end.func_177956_o(), end.func_177952_p())));
        this.centered = centered;
        this.renderMin = this.getBoundingBox().getMin();
        this.renderMax = this.getBoundingBox().getMax();
    }

    @Override
    public void writeShape(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setPos("viableStarts", this.start);
        funnel.setPos("end", this.end);
        tag.func_74757_a("centered", this.centered);
    }

    @Override
    public void readShape(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.start = funnel.getPos("viableStarts");
        this.end = funnel.getPos("end");
        this.centered = tag.func_74767_n("centered");
    }

    @Override
    public BlockPos getRenderBoxMin() {
        return this.renderMin;
    }

    @Override
    public BlockPos getRenderBoxMax() {
        return this.renderMax;
    }

    @Override
    public IShape rotate(Rotation rotation, IRegion in) {
        return this;
    }

    @Override
    public IShape translate(int x, int y, int z) {
        return new CylinderShape(this.start.func_177982_a(x, y, z), this.end.func_177982_a(x, y, z), this.centered);
    }

    @Override
    public IShape translate(BlockPos pos) {
        return this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (this.createFromCenter()) {
            int radiusSq = (int)this.start.func_177951_i((Vec3i)this.end);
            double dist = this.start.func_177982_a(0, y - this.start.func_177956_o(), 0).func_177954_c((double)x, (double)y, (double)z);
            return dist < (double)(radiusSq + 2);
        }
        if (!this.isUniform()) {
            double squareZ;
            BlockPos center = RegionHelp.getCenter(this.getBoundingBox());
            BlockPos point = center.func_177982_a(-x, -y, -z);
            int radiusX = this.getBoundingBox().getWidth() / 2;
            int radiusZ = this.getBoundingBox().getLength() / 2;
            double squareX = (double)point.func_177958_n() * (1.0 / (double)radiusX);
            double dist = Math.sqrt(new BlockPos(0, 0, 0).func_177954_c(squareX, 0.0, squareZ = (double)point.func_177952_p() * (1.0 / (double)radiusZ)));
            return dist < 1.0;
        }
        int size = Math.min(this.getBoundingBox().getWidth(), this.getBoundingBox().getLength());
        int xDif = this.start.func_177958_n() + (this.start.func_177958_n() <= this.end.func_177958_n() ? size : -size);
        int zDif = this.start.func_177952_p() + (this.start.func_177952_p() <= this.end.func_177952_p() ? size : -size);
        BlockPos newEnd = new BlockPos(xDif, this.end.func_177956_o(), zDif);
        BlockPos center = RegionHelp.getCenter(new Region(this.start, newEnd));
        BlockPos point = center.func_177982_a(-x, -y, -z);
        int radius = size / 2;
        double squareX = (double)point.func_177958_n() * (1.0 / (double)radius);
        double squareZ = (double)point.func_177952_p() * (1.0 / (double)radius);
        double dist = Math.sqrt(new BlockPos(0, 0, 0).func_177954_c(squareX, 0.0, squareZ));
        return dist < 1.0;
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> getShapeData() {
        if (this.data == null) {
            this.data = this.createShapeData();
        }
        return this.data;
    }
}

