/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.shapes;

import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.LineHelp;
import com.gildedgames.orbis.lib.util.RotationHelp;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LineShape
implements IShape {
    private World world;
    private BlockPos start;
    private BlockPos end;
    private int lineRadius;
    private Iterable<BlockPos.MutableBlockPos> data;

    private LineShape(World world) {
        this.world = world;
    }

    public LineShape(BlockPos start, BlockPos end) {
        this(start, end, 2);
    }

    public LineShape(BlockPos start, BlockPos end, int lineRadius) {
        this.start = start;
        this.end = end;
        this.lineRadius = lineRadius;
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> createShapeData() {
        return LineHelp.createLinePositions(this.lineRadius, this.start, this.end);
    }

    @Override
    public void write(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setPos("viableStarts", this.start);
        funnel.setPos("end", this.end);
        tag.func_74768_a("lineRadius", this.lineRadius);
    }

    @Override
    public void read(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.start = funnel.getPos("viableStarts");
        this.end = funnel.getPos("end");
        this.lineRadius = tag.func_74762_e("lineRadius");
    }

    @Override
    public IShape rotate(Rotation rotation, IRegion regionIn) {
        BlockPos newStart = RotationHelp.rotate(this.start, regionIn, rotation);
        BlockPos newEnd = RotationHelp.rotate(this.end, regionIn, rotation);
        return new LineShape(newStart, newEnd, this.lineRadius);
    }

    @Override
    public IShape translate(int x, int y, int z) {
        return new LineShape(this.start.func_177982_a(x, y, z), this.end.func_177982_a(x, y, z), this.lineRadius);
    }

    @Override
    public IShape translate(BlockPos pos) {
        return this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public IRegion getBoundingBox() {
        return new Region(this.start, this.end);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        boolean flag = false;
        for (BlockPos.MutableBlockPos pos : this.getShapeData()) {
            if (pos.func_177958_n() != x || pos.func_177956_o() != y || pos.func_177952_p() != z) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> getShapeData() {
        if (this.data == null) {
            this.data = this.createShapeData();
        }
        return this.data;
    }
}

