/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.data.shapes;

import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.shapes.AbstractShape;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class PyramidShape
extends AbstractShape {
    private BlockPos start;
    private BlockPos end;
    private boolean centered;
    private Iterable<BlockPos.MutableBlockPos> data;
    private BlockPos renderMin;
    private BlockPos renderMax;

    private PyramidShape(World world) {
        super(world);
    }

    public PyramidShape(BlockPos start, BlockPos end, boolean centered) {
        this.start = start;
        this.end = end;
        int radius = (int)Math.sqrt(this.start.func_177951_i((Vec3i)this.end));
        this.setBoundingBox(centered ? new Region(new BlockPos(-radius, -radius, -radius).func_177971_a((Vec3i)this.start), new BlockPos(radius, radius, radius).func_177971_a((Vec3i)this.start)) : new Region(start, new BlockPos(end.func_177958_n(), Math.max(end.func_177956_o(), start.func_177956_o()), end.func_177952_p())));
        this.centered = centered;
        this.renderMin = new BlockPos(this.getBoundingBox().getMin().func_177958_n(), this.start.func_177956_o(), this.getBoundingBox().getMin().func_177952_p());
        this.renderMax = this.getBoundingBox().getMax();
    }

    @Override
    public void writeShape(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        funnel.setPos("viableStarts", this.start);
        funnel.setPos("end", this.end);
        tag.func_74757_a("centered", this.centered);
    }

    @Override
    public void readShape(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.start = funnel.getPos("viableStarts");
        this.end = funnel.getPos("end");
        this.centered = tag.func_74767_n("centered");
    }

    @Override
    public BlockPos getRenderBoxMin() {
        return this.renderMin;
    }

    @Override
    public BlockPos getRenderBoxMax() {
        return this.renderMax;
    }

    @Override
    public IShape rotate(Rotation rotation, IRegion in) {
        return this;
    }

    @Override
    public IShape translate(int x, int y, int z) {
        return new PyramidShape(this.start.func_177982_a(x, y, z), this.end.func_177982_a(x, y, z), this.centered);
    }

    @Override
    public IShape translate(BlockPos pos) {
        return this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (this.createFromCenter()) {
            int radius = (int)Math.sqrt(this.start.func_177951_i((Vec3i)this.end));
            int width = radius - (y - this.start.func_177956_o());
            int xDif = Math.abs(x - this.start.func_177958_n());
            int zDif = Math.abs(z - this.start.func_177952_p());
            return xDif <= width && zDif <= width && y >= this.start.func_177956_o();
        }
        if (!this.isUniform()) {
            int lowestY = this.start.func_177956_o();
            int width = this.getBoundingBox().getWidth() - (y - lowestY);
            int length = this.getBoundingBox().getLength() - (y - lowestY);
            int xDif = Math.abs(x - this.start.func_177958_n());
            int zDif = Math.abs(z - this.start.func_177952_p());
            return xDif >= this.getBoundingBox().getWidth() - width && zDif >= this.getBoundingBox().getLength() - length && xDif <= width - 1 && zDif <= length - 1 && y >= lowestY;
        }
        int minSize = Math.min(this.getBoundingBox().getWidth(), this.getBoundingBox().getLength());
        int size = minSize - (y - this.start.func_177956_o());
        int xDif = Math.abs(x - this.start.func_177958_n());
        int zDif = Math.abs(z - this.start.func_177952_p());
        return xDif >= minSize - size && zDif >= minSize - size && xDif <= size - 1 && zDif <= size - 1 && y >= this.start.func_177956_o();
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public Iterable<BlockPos.MutableBlockPos> getShapeData() {
        if (this.data == null) {
            this.data = this.createShapeData();
        }
        return this.data;
    }
}

