/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.network;

import com.gildedgames.orbis.lib.network.INetworkMultipleParts;
import com.gildedgames.orbis.lib.network.util.IMessageMultipleParts;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkMultipleParts
implements INetworkMultipleParts {
    private final HashMap<Integer, ArrayList<byte[]>> packetParts = Maps.newHashMap();
    private SimpleNetworkWrapper instance;
    private int discriminant;

    public NetworkMultipleParts(String modID) {
        this.instance = NetworkRegistry.INSTANCE.newSimpleChannel(modID);
    }

    @Override
    public <REQ extends IMessage, REPLY extends IMessage> void reg(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, Side side) {
        this.instance.registerMessage(messageHandler, requestMessageType, this.discriminant++, side);
    }

    @Override
    public Map<Integer, ArrayList<byte[]>> getPacketParts() {
        return this.packetParts;
    }

    private IMessage[] fetchParts(IMessage message) {
        IMessage[] parts;
        if (message instanceof IMessageMultipleParts) {
            IMessageMultipleParts multipleParts = (IMessageMultipleParts)message;
            parts = multipleParts.getParts();
        } else {
            parts = new IMessage[]{message};
        }
        return parts;
    }

    @Override
    public void sendPacketToDimension(IMessage message, int dimension) {
        for (IMessage part : this.fetchParts(message)) {
            this.instance.sendToDimension(part, dimension);
        }
    }

    @Override
    public void sendPacketToAllPlayers(IMessage message) {
        for (IMessage part : this.fetchParts(message)) {
            this.instance.sendToAll(part);
        }
    }

    @Override
    public void sendPacketToAllPlayersExcept(IMessage message, EntityPlayerMP player) {
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        for (IMessage part : this.fetchParts(message)) {
            for (EntityPlayerMP p : playerList.func_181057_v()) {
                if (p == player) continue;
                this.instance.sendTo(part, p);
            }
        }
    }

    @Override
    public void sendPacketToPlayer(IMessage message, EntityPlayerMP player) {
        for (IMessage part : this.fetchParts(message)) {
            this.instance.sendTo(part, player);
        }
    }

    @Override
    public void sendPacketToWatching(IMessage message, EntityLivingBase entity, boolean includeSelf) {
        for (IMessage part : this.fetchParts(message)) {
            WorldServer world = (WorldServer)entity.field_70170_p;
            EntityTracker tracker = world.func_73039_n();
            for (EntityPlayer player : tracker.getTrackingPlayers((Entity)entity)) {
                this.sendPacketToPlayer(part, (EntityPlayerMP)player);
            }
            if (!includeSelf || !(entity instanceof EntityPlayer)) continue;
            this.sendPacketToPlayer(part, (EntityPlayerMP)entity);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void sendPacketToServer(IMessage message) {
        for (IMessage part : this.fetchParts(message)) {
            this.instance.sendToServer(part);
        }
    }
}

