/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.network.instances;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.network.util.IMessageMultipleParts;
import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public abstract class MessageHandler<REQ extends IMessage, RES extends IMessage>
implements IMessageHandler<REQ, RES> {
    protected RES processPart(REQ message, IMessageMultipleParts messageParts, EntityPlayer player) {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(messageParts.getPartData()));
        try {
            if (input.available() <= 0) {
                messageParts.read(Unpooled.buffer());
                return this.onMessage(message, player);
            }
            int partID = input.readInt();
            int packetTotalParts = input.readByte();
            byte packetPart = input.readByte();
            int dataLength = input.readInt();
            byte[] byteFragment = new byte[dataLength];
            input.read(byteFragment);
            input.close();
            ArrayList byteArray = OrbisLib.network().getPacketParts().get(partID);
            if (byteArray == null) {
                byteArray = Lists.newArrayList();
                OrbisLib.network().getPacketParts().put(partID, byteArray);
                for (int i = 0; i < packetTotalParts; ++i) {
                    byteArray.add(new byte[0]);
                }
            }
            byteArray.set(packetPart, byteFragment);
            boolean hasAllInfo = true;
            for (byte[] byteList : byteArray) {
                if (byteList.length != 0) continue;
                hasAllInfo = false;
                break;
            }
            if (hasAllInfo) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                for (byte[] byteList : byteArray) {
                    outputStream.write(byteList);
                }
                OrbisLib.network().getPacketParts().remove(partID);
                messageParts.read(Unpooled.copiedBuffer((byte[])outputStream.toByteArray()));
                return this.onMessage(message, player);
            }
        }
        catch (IOException e) {
            OrbisLib.LOGGER.error("Couldn't process message part!", (Throwable)e);
        }
        return null;
    }

    public abstract RES onMessage(REQ var1, EntityPlayer var2);
}

