/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.network.instances;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.network.instances.MessageHandlerClient;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketUnregisterDimension
implements IMessage {
    private int dimID;

    public PacketUnregisterDimension() {
    }

    public PacketUnregisterDimension(int dimID) {
        this.dimID = dimID;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimID);
    }

    public static class Handler
    extends MessageHandlerClient<PacketUnregisterDimension, PacketUnregisterDimension> {
        @Override
        public PacketUnregisterDimension onMessage(PacketUnregisterDimension message, EntityPlayer player) {
            if (DimensionManager.isDimensionRegistered((int)message.dimID)) {
                DimensionManager.unregisterDimension((int)message.dimID);
            } else {
                OrbisLib.LOGGER.warn("Tried to unregister dimension " + message.dimID + " by request of server, but it's not registered");
            }
            return null;
        }
    }
}

