/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.network.util;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.network.util.IMessageMultipleParts;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketMultipleParts
implements IMessage,
IMessageMultipleParts {
    private static final int PACKET_SIZE_LIMIT = 32000;
    private static int nextPartID = 0;
    private byte[] data;

    public PacketMultipleParts() {
    }

    public PacketMultipleParts(byte[] data) {
        this.data = data;
    }

    @Override
    public IMessage[] getParts() {
        int dataLength;
        ByteBuf buf = Unpooled.buffer();
        this.write(buf);
        byte[] byteArray = new byte[buf.readableBytes()];
        buf.readBytes(byteArray);
        int packetTotalParts = (int)Math.ceil((float)dataLength / 32000.0f);
        int partIndex = 0;
        IMessage[] parts = new IMessage[Math.max(1, packetTotalParts)];
        if (dataLength <= 0) {
            parts[0] = this.createPart(new byte[0]);
            return parts;
        }
        for (dataLength = byteArray.length; dataLength > 0; dataLength -= 32000) {
            int dataSize = partIndex >= packetTotalParts ? dataLength : (partIndex + 1) * 32000;
            byte[] byteFragment = Arrays.copyOfRange(byteArray, partIndex * 32000, dataSize);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream outputFragment = new DataOutputStream(byteStream);
            try {
                outputFragment.writeInt(nextPartID);
                outputFragment.writeByte(packetTotalParts);
                outputFragment.writeByte(partIndex);
                outputFragment.writeInt(dataLength > 32000 ? 32000 : dataLength);
                outputFragment.write(byteFragment);
            }
            catch (IOException e) {
                OrbisLib.LOGGER.error("Couldn't write output fragment for message parts!", (Throwable)e);
            }
            parts[partIndex] = this.createPart(byteStream.toByteArray());
            ++partIndex;
        }
        ++nextPartID;
        return parts;
    }

    public final void fromBytes(ByteBuf buf) {
        this.data = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), this.data);
    }

    public final void toBytes(ByteBuf buf) {
        buf.writeBytes(this.data);
    }

    @Override
    public byte[] getPartData() {
        return this.data;
    }

    @Override
    public void clearPartData() {
        this.data = null;
    }

    public abstract PacketMultipleParts createPart(byte[] var1);
}

