/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.processing;

import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

public class BlockAccessExtendedWrapper
implements IBlockAccessExtended {
    private final World world;

    public BlockAccessExtendedWrapper(World world) {
        this.world = world;
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean canAccess(BlockPos pos) {
        return this.world.func_175667_e(pos);
    }

    @Override
    public boolean canAccess(BlockPos pos, int radius) {
        return this.world.func_175697_a(pos, radius);
    }

    @Override
    public boolean canAccess(int x, int z) {
        return this.canAccess(new BlockPos(x, 0, z));
    }

    @Override
    public boolean canAccess(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.world.func_175707_a(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
    }

    @Override
    public BlockPos getTopPos(BlockPos pos) {
        return this.world.func_175672_r(pos);
    }

    @Override
    public int getTopY(int x, int z) {
        return this.world.func_189649_b(x, z);
    }

    @Override
    public void setBlockToAir(BlockPos pos) {
        this.world.func_175698_g(pos);
    }

    @Override
    public boolean setBlockState(BlockPos pos, IBlockState state) {
        return this.world.func_175656_a(pos, state);
    }

    @Override
    public boolean setBlockState(BlockPos pos, IBlockState state, int flags) {
        return this.world.func_180501_a(pos, state, flags);
    }

    @Override
    public void setTileEntity(BlockPos pos, TileEntity tileEntity) {
        this.world.func_175690_a(pos, tileEntity);
    }

    @Override
    public void spawnEntity(Entity entity) {
        this.world.func_72838_d(entity);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.world.func_175625_s(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return this.world.func_175626_b(pos, lightValue);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.world.func_175623_d(pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.world.func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.world.isSideSolid(pos, side, _default);
    }
}

