/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.processing;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.core.CreationData;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprintNetwork;
import com.gildedgames.orbis.lib.core.baking.BakedScheduleLayers;
import com.gildedgames.orbis.lib.core.baking.BlueprintNetworkNode;
import com.gildedgames.orbis.lib.core.baking.PotentialEntrance;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintNetworkData;
import com.gildedgames.orbis.lib.data.framework.generation.searching.PathwayUtil;
import com.gildedgames.orbis.lib.data.framework.interfaces.EnumFacingMultiple;
import com.gildedgames.orbis.lib.data.management.IDataIdentifier;
import com.gildedgames.orbis.lib.data.region.IMutableRegion;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.data.schedules.ScheduleEntranceHolder;
import com.gildedgames.orbis.lib.util.RotationHelp;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BlueprintNetworkGenerator {
    private IDebugNetworkPainter debugPainter;
    private BiConsumer<BakedBlueprint, BlockPos> nodeGenerator;
    private BlueprintNetworkData networkData;
    private BakedBlueprintNetwork bakedNetwork;
    private List<BlueprintData> potentialRooms;
    private BlueprintNetworkGenerationStep currentStep = BlueprintNetworkGenerationStep.START;
    private BlockPos pos;
    private World world;
    private Random rand;
    private List<BlueprintNetworkNode> unresolvedNodes = Lists.newArrayList();
    private List<BlueprintNetworkNode> queuedNodes = Lists.newArrayList();

    public BlueprintNetworkGenerator(BlueprintNetworkData networkData, ICreationData<?> creationData, IDebugNetworkPainter debugPainter, BiConsumer<BakedBlueprint, BlockPos> nodeGenerator) {
        this.networkData = networkData;
        this.debugPainter = debugPainter;
        this.nodeGenerator = nodeGenerator;
        this.pos = creationData.getPos();
        this.world = creationData.getWorld();
        this.rand = creationData.getRandom();
        this.bakedNetwork = new BakedBlueprintNetwork();
    }

    public boolean step() {
        this.unresolvedNodes.addAll(this.queuedNodes);
        this.queuedNodes.clear();
        switch (this.currentStep) {
            case START: {
                this.start();
                this.currentStep = BlueprintNetworkGenerationStep.GENERATE_NODES;
                return false;
            }
            case GENERATE_NODES: {
                Iterator<BlueprintNetworkNode> nodes = this.unresolvedNodes.iterator();
                if (nodes.hasNext()) {
                    BlueprintNetworkNode node = nodes.next();
                    if (this.generateNode(this.potentialRooms, this.rand, node)) {
                        nodes.remove();
                    }
                } else {
                    this.currentStep = BlueprintNetworkGenerationStep.FINISH;
                }
                return false;
            }
            case FINISH: {
                System.out.println("Finished!");
            }
        }
        return true;
    }

    private void start() {
        this.potentialRooms = this.fetchBlueprints(this.networkData.getRooms());
        BlueprintData start = this.potentialRooms.get(this.rand.nextInt(this.potentialRooms.size()));
        BakedBlueprint bakedStart = new BakedBlueprint(start, new CreationData(this.world).pos(this.pos));
        BlueprintNetworkNode startNode = new BlueprintNetworkNode(bakedStart, 0, this.rand);
        this.addNodeForGeneration(startNode);
    }

    private void addNodeForGeneration(BlueprintNetworkNode node) {
        this.bakedNetwork.addBakedNode(node);
        BakedBlueprint bakedNode = node.getBakedData();
        this.debugPainter.paint(bakedNode.getBakedRegion(), -12105913, 0);
        this.nodeGenerator.accept(bakedNode, BlockPos.field_177992_a);
        this.queuedNodes.add(node);
    }

    private boolean generateNode(List<BlueprintData> potentialRooms, Random rand, BlueprintNetworkNode node) {
        if (node.getDepth() < this.networkData.getTargetDepth() && node.getChildrenNodeCount() < 3 && node.getEntrancesToConnect().hasNext()) {
            PotentialEntrance potentialEntrance = node.getEntrancesToConnect().next();
            if (!node.getUsedEntrances().contains(potentialEntrance)) {
                BlueprintData nextRoom = this.randRoom(potentialRooms, rand);
                boolean generated = this.generateNextNode(potentialEntrance, nextRoom, node);
                int entranceColor = generated ? -3248687 : -3727314;
                Region region = new Region(potentialEntrance.getHolder().getBounds());
                region.add(node.getBakedData().getBakedRegion().getMin());
                if (generated) {
                    BakedBlueprint entranceToGenerate = new BakedBlueprint(potentialEntrance.getData(), new CreationData(this.world).rotation(potentialEntrance.getHolder().getRotation()));
                    entranceToGenerate.getBakedRegion().relocate(region.getMin());
                    this.nodeGenerator.accept(entranceToGenerate, BlockPos.field_177992_a);
                    this.debugPainter.paint(entranceToGenerate.getBakedRegion(), entranceColor, 2);
                }
            }
            return false;
        }
        return true;
    }

    private boolean generateNextNode(PotentialEntrance potentialEntrance, BlueprintData nextRoom, BlueprintNetworkNode comingFrom) {
        BakedScheduleLayers scheduleLayers;
        ScheduleEntranceHolder fromEntranceSchedule;
        BlueprintData fromEntrance;
        BakedBlueprint bakedComingFrom = comingFrom.getBakedData();
        ConnectionData connectionData = this.connectBlueprints(bakedComingFrom, fromEntrance = potentialEntrance.getData(), fromEntranceSchedule = potentialEntrance.getHolder(), nextRoom, scheduleLayers = new BakedScheduleLayers(nextRoom, this.world.field_73012_v));
        if (connectionData != null) {
            comingFrom.addChildrenNodeCount(1);
            CreationData creationData = new CreationData(this.world).pos(connectionData.pos.func_177971_a((Vec3i)bakedComingFrom.getBakedRegion().getMin())).rotation(connectionData.rotation);
            BakedBlueprint bakedNextRoom = new BakedBlueprint(nextRoom, scheduleLayers, creationData);
            bakedNextRoom.getScheduleLayers().bakePotentialEntrances(connectionData.rotation);
            BlueprintNetworkNode nextNode = new BlueprintNetworkNode(bakedNextRoom, comingFrom.getDepth() + 1, this.rand);
            nextNode.addUsedEntrance(connectionData.usedEntrance);
            this.addNodeForGeneration(nextNode);
            BakedBlueprint connectToEntrance = new BakedBlueprint(connectionData.usedEntrance.getData(), new CreationData(this.world).rotation(connectionData.usedEntranceRotation));
            connectToEntrance.getBakedRegion().relocate(connectionData.usedEntrancePos);
            this.nodeGenerator.accept(connectToEntrance, BlockPos.field_177992_a);
        }
        return connectionData != null;
    }

    private BlueprintData randRoom(List<BlueprintData> blueprints, Random rand) {
        return blueprints.get(rand.nextInt(blueprints.size()));
    }

    private ConnectionData connectBlueprints(BakedBlueprint fromRoom, BlueprintData fromEntrance, ScheduleEntranceHolder fromEntranceSchedule, BlueprintData connectingToRoom, BakedScheduleLayers roomScheduleLayers) {
        BlockPos fromMin = fromRoom.getBakedRegion().getMin();
        EnumFacingMultiple connectingFrom = PathwayUtil.getRotated(fromEntrance.getEntrance().getFacing(), fromEntranceSchedule.getRotation());
        Collections.shuffle(roomScheduleLayers.getPotentialEntrances(), this.rand);
        Region rect = new Region(new BlockPos(0, 0, 0), new BlockPos(connectingToRoom.getWidth() - 1, connectingToRoom.getHeight() - 1, connectingToRoom.getLength() - 1));
        for (PotentialEntrance potentialEntrance : roomScheduleLayers.getPotentialEntrances()) {
            BlueprintData toEntrance = potentialEntrance.getData();
            ScheduleEntranceHolder toEntranceSchedule = potentialEntrance.getHolder();
            EnumFacingMultiple connectingTo = PathwayUtil.getRotated(toEntrance.getEntrance().getFacing(), toEntranceSchedule.getRotation());
            Rotation rotation = Rotation.NONE;
            Rotation connectingFromRot = RotationHelp.fromFacing(connectingFrom.getOpposite());
            Rotation connectingToRot = RotationHelp.fromFacing(connectingTo);
            if (connectingFrom.canRotateToFaceEachother(connectingTo)) {
                rotation = RotationHelp.getRotationDifference(connectingToRot, connectingFromRot);
            } else if (connectingTo != connectingFrom) continue;
            Region trEntrance = new Region(toEntranceSchedule.getBounds());
            RotationHelp.rotateNew(trEntrance, rotation);
            IMutableRegion fromEntranceRect = fromEntranceSchedule.getBounds();
            Region adjacentEntrance = (Region)PathwayUtil.adjacent(fromEntranceRect, connectingFrom);
            int dx = adjacentEntrance.getMin().func_177958_n() - trEntrance.getMin().func_177958_n();
            int dy = adjacentEntrance.getMin().func_177956_o() - trEntrance.getMin().func_177956_o();
            int dz = adjacentEntrance.getMin().func_177952_p() - trEntrance.getMin().func_177952_p();
            Region finalRotatedRect = new Region(rect);
            RotationHelp.rotateNew(finalRotatedRect, rotation);
            finalRotatedRect.add(dx, dy, dz);
            finalRotatedRect.add(fromMin);
            if (this.collidesWithExistingNodes(finalRotatedRect)) continue;
            adjacentEntrance.add(fromMin);
            trEntrance.add(dx, dy, dz);
            trEntrance.add(fromMin);
            return new ConnectionData(rotation, new BlockPos(dx, dy, dz), potentialEntrance, trEntrance.getMin(), connectingToRot.func_185830_a(rotation));
        }
        return null;
    }

    private boolean collidesWithExistingNodes(IRegion region) {
        for (BlueprintNetworkNode node : this.bakedNetwork.getNodes()) {
            BakedBlueprint baked = node.getBakedData();
            if (!baked.getBakedRegion().intersectsWith(region)) continue;
            return true;
        }
        return false;
    }

    private List<BlueprintData> fetchBlueprints(List<IDataIdentifier> ids) {
        return ids.stream().map(id -> OrbisLib.services().getProjectManager().findData((IDataIdentifier)id)).filter(opt -> opt.isPresent() && opt.get() instanceof BlueprintData).map(opt -> (BlueprintData)opt.get()).collect(Collectors.toList());
    }

    public static class ConnectionData {
        public Rotation rotation;
        public BlockPos pos;
        public PotentialEntrance usedEntrance;
        public BlockPos usedEntrancePos;
        public Rotation usedEntranceRotation;

        public ConnectionData(Rotation rotation, BlockPos pos, PotentialEntrance usedEntrance, BlockPos usedEntrancePos, Rotation usedEntranceRotation) {
            this.rotation = rotation;
            this.pos = pos;
            this.usedEntrance = usedEntrance;
            this.usedEntrancePos = usedEntrancePos;
            this.usedEntranceRotation = usedEntranceRotation;
        }
    }

    public static enum BlueprintNetworkGenerationStep {
        START,
        GENERATE_NODES,
        FINISH;

    }

    public static interface IDebugNetworkPainter {
        public void paint(IRegion var1, int var2, int var3);
    }
}

