/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.processing;

import com.gildedgames.orbis.lib.block.BlockData;
import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.PlacedBlueprint;
import com.gildedgames.orbis.lib.core.PlacementCondition;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.core.baking.IBakedPosAction;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.blueprint.BlueprintDataPalette;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.util.RotationHelp;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataPrimer {
    private final IBlockAccessExtended access;

    public DataPrimer(IBlockAccessExtended primer) {
        this.access = primer;
    }

    @Nullable
    public World getWorld() {
        return this.access.getWorld();
    }

    public IBlockAccessExtended getAccess() {
        return this.access;
    }

    public void spawn(Entity entity) {
        this.access.spawnEntity(entity);
    }

    public boolean canGenerate(BakedBlueprint blueprint, BlockPos offset) {
        Region region = new Region(blueprint.getBakedRegion());
        region.add(offset);
        if (!this.access.canAccess(region.getMin().func_177958_n() - 2, region.getMin().func_177956_o() - 2, region.getMin().func_177952_p() - 2, region.getMax().func_177958_n() + 2, region.getMax().func_177956_o() + 2, region.getMax().func_177952_p() + 2)) {
            return false;
        }
        for (PlacementCondition condition : blueprint.getDefinition().getConditions()) {
            if (condition.validate(this.access, blueprint, region.getMin())) continue;
            return false;
        }
        return true;
    }

    public void setBlockInWorld(BlockData data, ICreationData<?> creationData) {
        this.setBlockInWorld(data.getBlockState(), data.getTileEntity(), creationData.getPos(), creationData);
    }

    public void setBlockInWorld(IBlockState state, NBTTagCompound entity, BlockPos pos, ICreationData<?> creationData) {
        if (state.func_185904_a() == Material.field_151579_a && !creationData.placeAir()) {
            return;
        }
        if (state.func_177230_c() == Blocks.field_189881_dj && !creationData.placesVoid()) {
            return;
        }
        this.access.setBlockState(pos, state, 18);
        if (entity != null && this.access.getWorld() != null) {
            TileEntity te = TileEntity.func_190200_a((World)this.access.getWorld(), (NBTTagCompound)entity);
            this.access.setTileEntity(pos, te);
        }
    }

    public void place(BakedBlueprint baked) {
        this.place(baked, BlockPos.field_177992_a);
    }

    public void place(BakedBlueprint baked, BlockPos relocateTo) {
        if (this.copyBlocksIntoWorld(relocateTo, baked, null, baked.getCreationData())) {
            for (BakedBlueprint child : baked.getBakedBlueprintChildren()) {
                this.place(child, relocateTo);
            }
            for (IBakedPosAction action : baked.getBakedPositionActions()) {
                action.call(this);
            }
        }
    }

    public void place(PlacedBlueprint placed, IRegion region) {
        BakedBlueprint baked = placed.getBaked();
        BlockPos offset = placed.getCreationData().getPos();
        if (this.copyBlocksIntoWorld(offset, baked, region, placed.getCreationData())) {
            for (BakedBlueprint child : baked.getBakedBlueprintChildren()) {
                this.place(child, offset);
            }
            Region intersection = placed.getRegion().fromIntersection(region);
            for (IBakedPosAction action : placed.getPendingPosActions()) {
                if (!intersection.contains(action.getPos())) continue;
                action.call(this);
            }
        }
    }

    public boolean create(BlockDataContainer blocks, ICreationData<?> data) {
        BlockPos min = data.getPos();
        BlockPos max = data.getPos().func_177982_a(blocks.getWidth() - 1, blocks.getHeight() - 1, blocks.getLength() - 1);
        return this.create(blocks, data, BlockPos.func_177980_a((BlockPos)min, (BlockPos)max), min);
    }

    public boolean create(BlockDataContainer blocks, ICreationData<?> data, Iterable<? extends BlockPos> toCreate, BlockPos min) {
        for (BlockPos blockPos : toCreate) {
            int z;
            int y;
            int x = blockPos.func_177958_n() - min.func_177958_n();
            IBlockState state = blocks.getBlockState(x, y = blockPos.func_177956_o() - min.func_177956_o(), z = blockPos.func_177952_p() - min.func_177952_p());
            NBTTagCompound entity = state.func_177230_c().hasTileEntity(state) ? blocks.getTileEntity((int)x, (int)y, (int)z).data : null;
            this.setBlockInWorld(state, entity, blockPos, data);
        }
        return true;
    }

    public void create(BlueprintDataPalette palette, ICreationData<?> data) {
        BlueprintData b = palette.fetchRandom(data.getWorld(), data.getRandom());
        Rotation rotation = data.getRotation();
        IRegion region = RotationHelp.regionFromCenter(data.getPos(), b, rotation);
        BakedBlueprint baked = new BakedBlueprint(b, (ICreationData<?>)data.clone().pos(region.getMin()));
        this.place(baked, data.getPos());
    }

    private boolean copyBlocksIntoWorld(BlockPos offset, BakedBlueprint blueprint, IRegion bounds, ICreationData<?> data) {
        return this.copyBlocksIntoWorld(offset, blueprint.getBlockData(), blueprint.getBakedRegion(), bounds, data);
    }

    public boolean copyBlocksIntoWorld(BlockPos offset, BlockDataContainer blocks, IRegion origin, IRegion bounds, ICreationData<?> data) {
        Region intersection;
        Region region = new Region(origin);
        region.add(offset);
        if (bounds != null) {
            if (!region.intersectsWith(bounds)) {
                return false;
            }
            intersection = region.fromIntersection(bounds);
        } else {
            intersection = region;
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)intersection.getMin(), (BlockPos)intersection.getMax())) {
            int z;
            int y;
            if (!data.shouldCreate(pos)) continue;
            int x = pos.func_177958_n() - region.getMin().func_177958_n();
            IBlockState state = blocks.getBlockState(x, y = pos.func_177956_o() - region.getMin().func_177956_o(), z = pos.func_177952_p() - region.getMin().func_177952_p());
            NBTTagCompound entity = state.func_177230_c().hasTileEntity(state) ? blocks.getTileEntity((int)x, (int)y, (int)z).data : null;
            this.setBlockInWorld(state, entity, pos, data);
        }
        return true;
    }
}

