/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util;

import com.gildedgames.orbis.lib.block.BlockDataContainer;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.RegionHelp;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlueprintHelper {
    public static BlockDataContainer fetchDifferenceBetween(BlockDataContainer oldState, BlockDataContainer newState) {
        if (oldState.getWidth() != newState.getWidth() || oldState.getHeight() != newState.getHeight() || oldState.getLength() != newState.getLength()) {
            throw new IllegalArgumentException("The two states passed through to 'BlueprintHelper.fetchDifferenceBetween' must be the same dimensions");
        }
        BlockDataContainer difference = new BlockDataContainer(Blocks.field_189881_dj.func_176223_P(), oldState.getWidth(), oldState.getHeight(), oldState.getLength());
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(oldState.getWidth() - 1, oldState.getHeight() - 1, oldState.getLength() - 1))) {
            IBlockState newBlock;
            IBlockState oldBlock = oldState.getBlockState((BlockPos)pos);
            if (oldBlock == (newBlock = newState.getBlockState((BlockPos)pos))) continue;
            difference.setBlockState(newBlock, (BlockPos)pos);
        }
        return difference;
    }

    public static BlockDataContainer fetchBlocksInside(IShape shape, World world) {
        return BlueprintHelper.fetchBlocksInside(shape, world, null);
    }

    public static BlockDataContainer fetchBlocksInside(IShape shape, World world, @Nullable BlockPos overridePos) {
        return BlueprintHelper.fetchBlocksInside(Blocks.field_150350_a.func_176223_P(), shape, world, overridePos);
    }

    public static BlockDataContainer fetchBlocksInside(IBlockState defaultState, IShape shape, World world, @Nullable BlockPos overridePos) {
        IRegion bb;
        IRegion iRegion = bb = overridePos != null ? new Region(shape.getBoundingBox()) : shape.getBoundingBox();
        if (overridePos != null) {
            RegionHelp.translate(bb, overridePos);
        }
        BlockDataContainer container = new BlockDataContainer(defaultState, bb);
        BlockPos min = shape.getBoundingBox().getMin();
        for (BlockPos blockPos : shape.createShapeData()) {
            BlockPos translated = blockPos.func_177982_a(-min.func_177958_n(), -min.func_177956_o(), -min.func_177952_p());
            container.setBlockState(world.func_180495_p(blockPos), translated);
            TileEntity entity = world.func_175625_s(blockPos);
            if (entity == null) continue;
            container.setTileEntity(entity, translated);
        }
        return container;
    }
}

