/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util;

import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiEvent;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.input.Mouse;

public class InputHelper {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static ScaledResolution resolution;

    public static int getMouseX() {
        return Mouse.getEventX() * InputHelper.getScreenWidth() / InputHelper.mc.field_71443_c;
    }

    public static int getMouseY() {
        return InputHelper.getScreenHeight() - Mouse.getEventY() * InputHelper.getScreenHeight() / InputHelper.mc.field_71440_d - 1;
    }

    private static boolean isHovered(Rect dim) {
        if (dim == null) {
            return false;
        }
        return (float)InputHelper.getMouseX() >= dim.x() && (float)InputHelper.getMouseY() >= dim.y() && (float)InputHelper.getMouseX() < dim.x() + dim.width() && (float)InputHelper.getMouseY() < dim.y() + dim.height();
    }

    public static void refreshResolution() {
        resolution = new ScaledResolution(mc);
    }

    public static int getScreenWidth() {
        InputHelper.refreshResolution();
        return resolution.func_78326_a();
    }

    public static int getScreenHeight() {
        InputHelper.refreshResolution();
        return resolution.func_78328_b();
    }

    private static boolean isHovered(List<IGuiElement> elements, IGuiElement ignore) {
        if (elements == null) {
            return false;
        }
        for (IGuiElement element : elements) {
            if (element == ignore || !InputHelper.isHovered(element.state())) continue;
            return true;
        }
        return false;
    }

    public static boolean isHovered(RectHolder holder) {
        if (holder == null) {
            return false;
        }
        return InputHelper.isHovered(holder.dim());
    }

    private static boolean isHoveredAndTopElement(IGuiElement check) {
        return InputHelper.isHoveredAndTopElement(check, true);
    }

    private static boolean isHoveredAndTopElement(IGuiElement check, boolean topElementsCanBeChildren) {
        IGuiViewer viewer;
        Iterator<IGuiElement> iterator;
        if (check == null) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof IGuiViewer && (iterator = (viewer = (IGuiViewer)Minecraft.func_71410_x().field_71462_r).getAllVisibleElements().iterator()).hasNext()) {
            IGuiElement child = iterator.next();
            return false;
        }
        return InputHelper.isHovered(check.state().dim());
    }

    private static boolean isViable(IGuiViewer viewer, IGuiElement element, boolean topElementsCanBeChildren) {
        return topElementsCanBeChildren || !viewer.getAllVisibleElementsBelow(element).contains(element);
    }

    public static void markHoveredAndTopElements(IGuiViewer viewer, boolean topElementsCanBeChildren) {
        int highestZOrder = Integer.MIN_VALUE;
        ArrayList topHovered = Lists.newArrayList();
        block0: for (IGuiElement element : viewer.getAllVisibleElements()) {
            element.state().setHoveredAndTopElement(false);
            for (IGuiEvent event : element.state().getEvents()) {
                if (event.canBeHovered(element)) continue;
                element.state().setHovered(false);
                continue block0;
            }
            element.state().setHovered(InputHelper.isHovered(element));
            if (!element.state().isHovered() || !element.state().canBeTopHoverElement() || !element.state().isEnabled()) continue;
            if (element.state().getZOrder() > highestZOrder) {
                topHovered.clear();
            }
            topHovered.add(element);
            highestZOrder = element.state().getZOrder();
        }
        for (IGuiElement element : topHovered) {
            InputHelper.recursiveSetHoverAndParents(element);
        }
    }

    private static void recursiveSetHoverAndParents(IGuiElement element) {
        element.state().setHoveredAndTopElement(true);
        for (IGuiElement parent : element.context().getParents()) {
            if (!parent.state().canBeTopHoverElement()) continue;
            InputHelper.recursiveSetHoverAndParents(parent);
        }
    }

    public static float getScaleFactor() {
        return resolution.func_78325_e();
    }

    public static Pos2D getCenter() {
        return Pos2D.flush(InputHelper.getScreenWidth() / 2, InputHelper.getScreenHeight() / 2);
    }

    public static Pos2D getBottomCenter() {
        return InputHelper.getCenter().clone().addY(InputHelper.getScreenHeight() / 2).flush();
    }

    public static Pos2D getBottomRight() {
        return InputHelper.getBottomCenter().clone().addX(InputHelper.getScreenWidth() / 2).flush();
    }

    public static Pos2D getBottomLeft() {
        return InputHelper.getBottomRight().clone().addX(-InputHelper.getScreenWidth()).flush();
    }

    public static Pos2D getCenterLeft() {
        return InputHelper.getCenter().clone().addX(-InputHelper.getScreenWidth() / 2).flush();
    }

    public static Pos2D getCenterRight() {
        return InputHelper.getCenterLeft().clone().addX(InputHelper.getScreenWidth()).flush();
    }

    public static Pos2D getTopCenter() {
        return InputHelper.getCenter().clone().addY(-InputHelper.getScreenHeight() / 2).flush();
    }

    public static Pos2D getTopLeft() {
        return InputHelper.getTopCenter().clone().addX(-InputHelper.getScreenWidth() / 2).flush();
    }

    public static Pos2D getTopRight() {
        return InputHelper.getTopLeft().clone().addX(InputHelper.getScreenWidth()).flush();
    }
}

