/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util;

import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;

public class LineHelp {
    public static Iterable<BlockPos.MutableBlockPos> createLinePositions(int lineRadius, BlockPos start, BlockPos end) {
        ArrayList<BlockPos.MutableBlockPos> lineData = new ArrayList<BlockPos.MutableBlockPos>();
        for (int lineX = -lineRadius + 1; lineX < lineRadius - (lineRadius == 1 ? 0 : 1); ++lineX) {
            for (int lineY = -lineRadius + 1; lineY < lineRadius - (lineRadius == 1 ? 0 : 1); ++lineY) {
                for (int lineZ = -lineRadius + 1; lineZ < lineRadius - (lineRadius == 1 ? 0 : 1); ++lineZ) {
                    boolean steepXZ;
                    boolean steepXY;
                    BlockPos s = start.func_177982_a(lineX, lineY, lineZ);
                    BlockPos e = end.func_177982_a(lineX, lineY, lineZ);
                    boolean bl = steepXY = Math.abs(e.func_177956_o() - s.func_177956_o()) > Math.abs(e.func_177958_n() - s.func_177958_n());
                    if (steepXY) {
                        int tempY = s.func_177956_o();
                        s = new BlockPos(tempY, s.func_177958_n(), s.func_177952_p());
                        tempY = e.func_177956_o();
                        e = new BlockPos(tempY, e.func_177958_n(), e.func_177952_p());
                    }
                    boolean bl2 = steepXZ = Math.abs(e.func_177952_p() - s.func_177952_p()) > Math.abs(e.func_177958_n() - s.func_177958_n());
                    if (steepXZ) {
                        int tempZ = s.func_177952_p();
                        s = new BlockPos(tempZ, s.func_177956_o(), s.func_177958_n());
                        tempZ = e.func_177952_p();
                        e = new BlockPos(tempZ, e.func_177956_o(), e.func_177958_n());
                    }
                    int deltaX = Math.abs(e.func_177958_n() - s.func_177958_n());
                    int deltaY = Math.abs(e.func_177956_o() - s.func_177956_o());
                    int deltaZ = Math.abs(e.func_177952_p() - s.func_177952_p());
                    int errorXY = deltaX / 2;
                    int errorXZ = deltaX / 2;
                    int stepX = s.func_177958_n() > e.func_177958_n() ? -1 : 1;
                    int stepY = s.func_177956_o() > e.func_177956_o() ? -1 : 1;
                    int stepZ = s.func_177952_p() > e.func_177952_p() ? -1 : 1;
                    int z = s.func_177952_p();
                    int y = s.func_177956_o();
                    int lineSegments = 0;
                    for (int x = s.func_177958_n(); x != e.func_177958_n(); x += stepX) {
                        int xCopy = x;
                        int yCopy = y;
                        int zCopy = z;
                        if (steepXZ) {
                            int tempZ = zCopy;
                            zCopy = xCopy;
                            xCopy = tempZ;
                        }
                        if (steepXY) {
                            int tempY = yCopy;
                            yCopy = xCopy;
                            xCopy = tempY;
                        }
                        for (int x1 = 0; x1 != stepX; x1 += stepX) {
                            for (int z1 = 0; z1 != stepZ; z1 += stepZ) {
                                for (int y1 = 0; y1 != stepY; y1 += stepY) {
                                    lineData.add(new BlockPos.MutableBlockPos(xCopy + x1, yCopy + y1, zCopy + z1));
                                }
                            }
                        }
                        if (++lineSegments % 5 == 0) {
                            // empty if block
                        }
                        errorXZ -= deltaZ;
                        if ((errorXY -= deltaY) < 0) {
                            y += stepY;
                            errorXY += deltaX;
                        }
                        if (errorXZ >= 0) continue;
                        z += stepZ;
                        errorXZ += deltaX;
                    }
                }
            }
        }
        return lineData;
    }
}

