/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectFilter {
    public static <T> List<T> getTypesFrom(Collection<?> list, Class<? extends T> typeClass) {
        ArrayList returnList = new ArrayList();
        for (Object obj : list) {
            if (obj == null || !typeClass.isAssignableFrom(obj.getClass())) continue;
            returnList.add(obj);
        }
        return returnList;
    }

    public static <T> List<T> getTypesFrom(Collection<T> list, FilterCondition<T> condition) {
        ArrayList<T> returnList = new ArrayList<T>();
        for (T obj : list) {
            if (obj == null || !condition.isType(obj)) continue;
            returnList.add(obj);
        }
        return returnList;
    }

    public static <T> T getFirstFrom(Collection<?> list, Class<? extends T> typeClass) {
        for (Object obj : list) {
            if (obj == null || obj.getClass() != typeClass) continue;
            return (T)obj;
        }
        return null;
    }

    public static abstract class FilterCondition<T> {
        private final List<T> data;

        public FilterCondition(List<T> data) {
            this.data = data;
        }

        public List<T> data() {
            return this.data;
        }

        public abstract boolean isType(T var1);
    }
}

