/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util;

import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.IMutableRegion;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.IRegionHolder;
import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.data.region.Region;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class RegionHelp {
    public static boolean sameDim(IDimensions d1, IDimensions d2) {
        return d1.getLength() == d2.getLength() && d1.getWidth() == d2.getWidth() && d1.getHeight() == d2.getHeight();
    }

    public static boolean intersects2D(IShape shape1, IShape shape2) {
        for (BlockPos blockPos : shape1.getShapeData()) {
            if (!shape2.contains(blockPos)) continue;
            return true;
        }
        return false;
    }

    public static <T extends IRegionHolder> Optional<T> findIntersecting(Iterable<T> holders, Vec3i origin, Vec3i pos) {
        for (IRegionHolder e : holders) {
            Optional<IRegionHolder> opt = RegionHelp.findIntersecting(e, origin, pos);
            if (!opt.isPresent()) continue;
            return opt;
        }
        return Optional.empty();
    }

    public static <T extends IRegionHolder> Optional<T> findIntersecting(T holder, Vec3i origin, Vec3i pos) {
        int minX = holder.getBounds().getMin().func_177958_n() + origin.func_177958_n();
        int minY = holder.getBounds().getMin().func_177956_o() + origin.func_177956_o();
        int minZ = holder.getBounds().getMin().func_177952_p() + origin.func_177952_p();
        int maxX = minX + holder.getBounds().getWidth() - 1;
        int maxY = minY + holder.getBounds().getHeight() - 1;
        int maxZ = minZ + holder.getBounds().getLength() - 1;
        if (pos.func_177958_n() >= minX && pos.func_177958_n() <= maxX && pos.func_177956_o() >= minY && pos.func_177956_o() <= maxY && pos.func_177952_p() >= minZ && pos.func_177952_p() <= maxZ) {
            return Optional.of(holder);
        }
        return Optional.empty();
    }

    public static boolean contains(IShape shape1, IShape shape2) {
        for (BlockPos blockPos : shape1.getShapeData()) {
            if (shape2.contains(blockPos)) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getBottomCenter(IRegion region) {
        BlockPos min = region.getMin();
        return new BlockPos(min.func_177958_n() + region.getWidth() / 2, min.func_177956_o(), min.func_177952_p() + region.getLength() / 2);
    }

    public static BlockPos getCenter(IRegion region) {
        BlockPos min = region.getMin();
        return new BlockPos(min.func_177958_n() + region.getWidth() / 2, min.func_177956_o() + region.getHeight() / 2, min.func_177952_p() + region.getLength() / 2);
    }

    public static boolean intersects3D(IRegion a, IRegion b) {
        return RegionHelp.intersects3D(a, b, 0);
    }

    public static boolean intersects3D(IRegion a, IRegion b, int padding) {
        return a.getMin().func_177958_n() - padding <= b.getMax().func_177958_n() + padding && a.getMax().func_177958_n() + padding >= b.getMin().func_177958_n() - padding && a.getMin().func_177952_p() - padding <= b.getMax().func_177952_p() + padding && a.getMax().func_177952_p() >= b.getMin().func_177952_p() + padding && a.getMin().func_177956_o() - padding <= b.getMax().func_177956_o() + padding && a.getMax().func_177956_o() + padding >= b.getMin().func_177956_o();
    }

    public static boolean intersects(IRegion a, IRegion b, int padding) {
        return a.getMin().func_177958_n() - padding <= b.getMax().func_177958_n() + padding && a.getMax().func_177958_n() + padding >= b.getMin().func_177958_n() - padding && a.getMin().func_177952_p() - padding <= b.getMax().func_177952_p() + padding && a.getMax().func_177952_p() >= b.getMin().func_177952_p() + padding;
    }

    public static boolean intersects(IRegion a, IRegion b) {
        return RegionHelp.intersects(a, b, 0);
    }

    public static <T extends IRegion> void fetchIntersecting2D(T region, List<T> regions, List<T> addTo, int padding) {
        for (IRegion r : regions) {
            if (!RegionHelp.intersects(r, region, padding)) continue;
            addTo.add(r);
        }
    }

    public static boolean contains(IRegion region1, IRegion region2) {
        BlockPos min1 = region1.getMin();
        BlockPos min2 = region2.getMin();
        BlockPos max1 = region1.getMax();
        BlockPos max2 = region2.getMax();
        return max1.func_177958_n() >= max2.func_177958_n() && min1.func_177958_n() <= min2.func_177958_n() && max1.func_177952_p() >= max2.func_177952_p() && min1.func_177952_p() <= min2.func_177952_p() && max1.func_177956_o() >= max2.func_177956_o() && min1.func_177956_o() <= min2.func_177956_o();
    }

    public static boolean contains(IRegion region, BlockPos pos) {
        return RegionHelp.contains(region, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
    }

    public static boolean contains(IRegion region, float x, float y, float z) {
        BlockPos min = region.getMin();
        BlockPos max = region.getMax();
        return x <= (float)max.func_177958_n() && x >= (float)min.func_177958_n() && y <= (float)max.func_177956_o() && y >= (float)min.func_177956_o() && z <= (float)max.func_177952_p() && z >= (float)min.func_177952_p();
    }

    public static boolean contains(IDimensions region, BlockPos pos) {
        return RegionHelp.contains(region, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
    }

    public static boolean contains(IDimensions region, float x, float y, float z) {
        BlockPos min = BlockPos.field_177992_a;
        BlockPos max = new BlockPos(region.getWidth() - 1, region.getHeight() - 1, region.getLength() - 1);
        return x <= (float)max.func_177958_n() && x >= (float)min.func_177958_n() && y <= (float)max.func_177956_o() && y >= (float)min.func_177956_o() && z <= (float)max.func_177952_p() && z >= (float)min.func_177952_p();
    }

    public static boolean containsIgnoreY(IRegion region, BlockPos pos) {
        return RegionHelp.containsIgnoreY(region, pos.func_177958_n(), pos.func_177952_p());
    }

    public static boolean containsIgnoreY(IRegion region, float x, float z) {
        BlockPos min = region.getMin();
        BlockPos max = region.getMax();
        return x <= (float)max.func_177958_n() && x >= (float)min.func_177958_n() && z <= (float)max.func_177952_p() && z >= (float)min.func_177952_p();
    }

    public static boolean isACorner(BlockPos pos, IRegion region) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos min = region.getMin();
        BlockPos max = region.getMax();
        boolean xOnEdge = min.func_177958_n() == x || max.func_177958_n() == x;
        boolean yOnEdge = min.func_177956_o() == y || max.func_177956_o() == y;
        boolean zOnEdge = min.func_177952_p() == z || max.func_177952_p() == z;
        return xOnEdge && yOnEdge && zOnEdge;
    }

    public static void translate(IMutableRegion region, BlockPos pos) {
        RegionHelp.translate(region, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void translate(IMutableRegion region, int translateX, int translateY, int translateZ) {
        BlockPos min = region.getMin();
        BlockPos newMin = new BlockPos(min.func_177958_n() + translateX, min.func_177956_o() + translateY, min.func_177952_p() + translateZ);
        BlockPos max = region.getMax();
        BlockPos newMax = new BlockPos(max.func_177958_n() + translateX, max.func_177956_o() + translateY, max.func_177952_p() + translateZ);
        region.setBounds(newMin, newMax);
    }

    public static void relocate(IMutableRegion region, BlockPos newMin) {
        BlockPos min = region.getMin();
        BlockPos max = region.getMax();
        int difX = max.func_177958_n() - min.func_177958_n();
        int difY = max.func_177956_o() - min.func_177956_o();
        int difZ = max.func_177952_p() - min.func_177952_p();
        BlockPos newMax = new BlockPos(newMin.func_177958_n() + difX, newMin.func_177956_o() + difY, newMin.func_177952_p() + difZ);
        region.setBounds(newMin, newMax);
    }

    public static BlockPos getMin(BlockPos corner1, BlockPos corner2) {
        int minX = Math.min(corner1.func_177958_n(), corner2.func_177958_n());
        int minY = Math.min(corner1.func_177956_o(), corner2.func_177956_o());
        int minZ = Math.min(corner1.func_177952_p(), corner2.func_177952_p());
        return new BlockPos(minX, minY, minZ);
    }

    public static BlockPos getMax(BlockPos corner1, BlockPos corner2) {
        int maxX = Math.max(corner1.func_177958_n(), corner2.func_177958_n());
        int maxY = Math.max(corner1.func_177956_o(), corner2.func_177956_o());
        int maxZ = Math.max(corner1.func_177952_p(), corner2.func_177952_p());
        return new BlockPos(maxX, maxY, maxZ);
    }

    public static BlockPos getMax(BlockPos min, int width, int height, int length) {
        return new BlockPos(min.func_177958_n() + width - 1, min.func_177956_o() + height - 1, min.func_177952_p() + length - 1);
    }

    public static BlockPos getMax(BlockPos min, IDimensions dimensions) {
        return RegionHelp.getMax(min, dimensions.getWidth(), dimensions.getHeight(), dimensions.getLength());
    }

    public static BlockPos getMin(Collection<? extends IRegion> regions) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (IRegion iRegion : regions) {
            BlockPos min = iRegion.getMin();
            minX = Math.min(minX, min.func_177958_n());
            minY = Math.min(minY, min.func_177956_o());
            minZ = Math.min(minZ, min.func_177952_p());
        }
        return new BlockPos(minX, minY, minZ);
    }

    public static BlockPos getMax(Collection<? extends IRegion> regions) {
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (IRegion iRegion : regions) {
            BlockPos max = iRegion.getMax();
            maxX = Math.max(maxX, max.func_177958_n());
            maxY = Math.max(maxY, max.func_177956_o());
            maxZ = Math.max(maxZ, max.func_177952_p());
        }
        return new BlockPos(maxX, maxY, maxZ);
    }

    public static IRegion createRegion(BlockPos corner1, BlockPos corner2) {
        return new Region(corner1, corner2);
    }

    public static IRegion empty() {
        return new Region(new BlockPos(0, 0, 0), new BlockPos(0, 0, 0));
    }

    public static int getWidth(BlockPos min, BlockPos max) {
        return max.func_177958_n() - min.func_177958_n() + 1;
    }

    public static int getHeight(BlockPos min, BlockPos max) {
        return max.func_177956_o() - min.func_177956_o() + 1;
    }

    public static int getLength(BlockPos min, BlockPos max) {
        return max.func_177952_p() - min.func_177952_p() + 1;
    }

    public static IRegion intersection(IRegion region1, IRegion region2) {
        if (RegionHelp.intersects2D(region1, region2)) {
            BlockPos min1 = region1.getMin();
            BlockPos min2 = region2.getMin();
            BlockPos max1 = region1.getMax();
            BlockPos max2 = region2.getMax();
            return new Region(new BlockPos(Math.max(min1.func_177958_n(), min2.func_177958_n()), Math.max(min1.func_177956_o(), min2.func_177956_o()), Math.max(min1.func_177952_p(), min2.func_177952_p())), new BlockPos(Math.min(max1.func_177958_n(), max2.func_177958_n()), Math.min(max1.func_177956_o(), max2.func_177956_o()), Math.min(max1.func_177952_p(), max2.func_177952_p())));
        }
        return RegionHelp.empty();
    }

    public static IRegion expand(IRegion region, int width) {
        return new Region(region.getMin().func_177982_a(-width, -width, -width), region.getMax().func_177982_a(width, width, width));
    }

    public static IRegion subtract(IRegion region, int x, int y, int z) {
        return new Region(region.getMin().func_177982_a(-x, -y, -z), region.getMax().func_177982_a(-x, -y, -z));
    }
}

