/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util;

import com.gildedgames.orbis.lib.data.blueprint.BlueprintData;
import com.gildedgames.orbis.lib.data.framework.interfaces.EnumFacingMultiple;
import com.gildedgames.orbis.lib.data.pathway.IEntrance;
import com.gildedgames.orbis.lib.data.region.IDimensions;
import com.gildedgames.orbis.lib.data.region.IMutableRegion;
import com.gildedgames.orbis.lib.data.region.IRegion;
import com.gildedgames.orbis.lib.data.region.Region;
import com.gildedgames.orbis.lib.util.OrbisTuple;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class RotationHelp {
    public static void rotateNew(IMutableRegion region, Rotation rotation) {
        BlockPos min = RotationHelp.transformedBlockPos(region.getMin(), rotation);
        BlockPos max = RotationHelp.transformedBlockPos(region.getMax(), rotation);
        region.setBounds(min, max);
    }

    public static BlockPos transformedBlockPos(BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
            }
            case CLOCKWISE_90: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
        }
        return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static List<IEntrance> getEntrances(BlueprintData data, Rotation rotation, BlockPos center) {
        ArrayList<IEntrance> newList = new ArrayList<IEntrance>();
        return newList;
    }

    public static Iterable<OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos>> getAllInRegionRotated(IRegion region, Rotation rotation) {
        return RotationHelp.getAllInBoxRotated(region.getMin(), region.getMax(), rotation, null);
    }

    public static Iterable<OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos>> getAllInBoxRotated(BlockPos from, BlockPos to, Rotation rotation) {
        return RotationHelp.getAllInBoxRotated(from, to, rotation, null);
    }

    public static Iterable<OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos>> getAllInBoxRotated(BlockPos from, final BlockPos to, Rotation rotation, final @Nullable IRegion relocateTo) {
        final boolean clockwise = RotationHelp.getGoClockwise(rotation, Rotation.NONE);
        final int rotAmount = Math.abs(RotationHelp.getRotationAmount(rotation, Rotation.NONE));
        final BlockPos min = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        final BlockPos max = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        int width = RegionHelp.getWidth(min, max);
        int length = RegionHelp.getLength(min, max);
        int centerX = min.func_177958_n() + width / 2;
        int centerZ = min.func_177952_p() + length / 2;
        final BlockPos center = new BlockPos(centerX, from.func_177956_o(), centerZ);
        final int roundingX = RotationHelp.getRounding(width);
        final int roundingZ = RotationHelp.getRounding(length);
        return new Iterable<OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos>>(){

            @Override
            public Iterator<OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos>> iterator() {
                return new AbstractIterator<OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos>>(){
                    private BlockPos.MutableBlockPos theBlockPos = null;
                    private BlockPos.MutableBlockPos rotated = null;
                    private OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos> theTuple;

                    void doRotate() {
                        RotationHelp.setRotated(this.rotated, (BlockPos)this.theBlockPos, center, roundingX, roundingZ, rotAmount, clockwise);
                    }

                    OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos> computeNext0() {
                        if (this.theBlockPos == null) {
                            this.theBlockPos = new BlockPos.MutableBlockPos(min.func_177958_n(), min.func_177956_o(), min.func_177952_p());
                            this.rotated = new BlockPos.MutableBlockPos(0, 0, 0);
                            this.doRotate();
                            if (relocateTo != null) {
                                int xDif = (relocateTo.getMax().func_177958_n() - to.func_177958_n()) / 2;
                                int zDif = (relocateTo.getMax().func_177952_p() - to.func_177952_p()) / 2;
                                this.rotated.func_181079_c(this.rotated.func_177958_n() + xDif, this.rotated.func_177956_o(), this.rotated.func_177952_p() + zDif);
                            }
                            this.theTuple = new OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos>(this.theBlockPos, this.rotated);
                            return this.theTuple;
                        }
                        if (this.theBlockPos.equals((Object)max)) {
                            return (OrbisTuple)this.endOfData();
                        }
                        int i = this.theBlockPos.func_177958_n();
                        int k = this.theBlockPos.func_177956_o();
                        int j = this.theBlockPos.func_177952_p();
                        if (i < max.func_177958_n()) {
                            ++i;
                        } else if (k < max.func_177956_o()) {
                            i = min.func_177958_n();
                            ++k;
                        } else if (j < max.func_177952_p()) {
                            i = min.func_177958_n();
                            k = min.func_177956_o();
                            ++j;
                        }
                        RotationHelp.setX(this.theBlockPos, i);
                        this.theBlockPos.func_185336_p(k);
                        RotationHelp.setZ(this.theBlockPos, j);
                        this.doRotate();
                        if (relocateTo != null) {
                            int xDif = (relocateTo.getMax().func_177958_n() - to.func_177958_n()) / 2;
                            int zDif = (relocateTo.getMax().func_177952_p() - to.func_177952_p()) / 2;
                            this.rotated.func_181079_c(this.rotated.func_177958_n() + xDif, this.rotated.func_177956_o(), this.rotated.func_177952_p() + zDif);
                        }
                        return this.theTuple;
                    }

                    protected OrbisTuple<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos> computeNext() {
                        return this.computeNext0();
                    }
                };
            }
        };
    }

    public static int getRounding(int dimension) {
        return dimension % 2 == 0 ? 1 : 0;
    }

    public static void setX(BlockPos.MutableBlockPos pos, int x) {
        pos.func_181079_c(x, pos.func_177956_o(), pos.func_177952_p());
    }

    public static void setZ(BlockPos.MutableBlockPos pos, int z) {
        pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), z);
    }

    public static void setRotated(BlockPos.MutableBlockPos rotated, BlockPos toRotate, BlockPos center, int roundingX, int roundingZ, int rotAmount, boolean clockwise) {
        int centerX = center.func_177958_n();
        int centerZ = center.func_177952_p();
        int relX = toRotate.func_177958_n() - centerX;
        rotated.func_185336_p(toRotate.func_177956_o());
        int relZ = toRotate.func_177952_p() - centerZ;
        if (rotAmount == 0) {
            RotationHelp.setX(rotated, toRotate.func_177958_n());
            RotationHelp.setZ(rotated, toRotate.func_177952_p());
        } else if (rotAmount == 1) {
            if (clockwise) {
                RotationHelp.setX(rotated, centerX - relZ - roundingZ);
                RotationHelp.setZ(rotated, centerZ + relX);
            } else {
                RotationHelp.setX(rotated, centerX + relZ);
                RotationHelp.setZ(rotated, centerZ - relX - roundingX);
            }
        } else {
            RotationHelp.setX(rotated, centerX - relX - roundingX);
            RotationHelp.setZ(rotated, centerZ - relZ - roundingZ);
        }
    }

    public static BlockPos rotate(BlockPos pos, BlockPos center, Rotation rotation, int width, int length) {
        int rotAmount = RotationHelp.getRotationAmount(rotation, Rotation.NONE);
        boolean clockwise = RotationHelp.getGoClockwise(rotation, Rotation.NONE);
        BlockPos.MutableBlockPos rotated = new BlockPos.MutableBlockPos(0, 0, 0);
        RotationHelp.setRotated(rotated, pos, center, RotationHelp.getRounding(width), RotationHelp.getRounding(length), rotAmount, clockwise);
        return rotated;
    }

    public static BlockPos rotate(BlockPos pos, IRegion region, Rotation rotation) {
        return RotationHelp.rotate(pos, RegionHelp.getBottomCenter(region), rotation, region.getWidth(), region.getLength());
    }

    public static IRegion rotate(IRegion region, BlockPos center, Rotation rotation, int width, int length) {
        BlockPos corner1 = RotationHelp.rotate(region.getMin(), center, rotation, width, length);
        BlockPos corner2 = RotationHelp.rotate(region.getMax(), center, rotation, width, length);
        return new Region(corner1, corner2);
    }

    public static IRegion rotate(IRegion region, IRegion rotateIn, Rotation rotation) {
        return RotationHelp.rotate(region, RegionHelp.getBottomCenter(rotateIn), rotation, rotateIn.getWidth(), rotateIn.getLength());
    }

    public static IRegion rotate(IRegion region, Rotation rotation) {
        BlockPos center = RegionHelp.getBottomCenter(region);
        return RotationHelp.regionFromCenter(center, region, rotation);
    }

    public static IRegion regionFromCenter(int centerX, int centerY, int centerZ, IDimensions dimensions, Rotation rotation) {
        int width = RotationHelp.getWidth(dimensions, rotation);
        int length = RotationHelp.getLength(dimensions, rotation);
        int roundingX = RotationHelp.getRounding(width);
        int roundingZ = RotationHelp.getRounding(length);
        int modX = 0;
        int modZ = 0;
        boolean clockwise = RotationHelp.getGoClockwise(rotation, Rotation.NONE);
        int rotAmount = Math.abs(RotationHelp.getRotationAmount(rotation, Rotation.NONE));
        BlockPos min = new BlockPos(centerX - width / 2 + modX, centerY, centerZ - length / 2 + modZ);
        BlockPos max = new BlockPos(min.func_177958_n() + width - 1, min.func_177956_o() + dimensions.getHeight() - 1, min.func_177952_p() + length - 1);
        return new Region(min, max);
    }

    public static IRegion regionFromCenter(BlockPos center, IDimensions dimensions, Rotation rotation) {
        return RotationHelp.regionFromCenter(center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), dimensions, rotation);
    }

    public static Rotation fromFacing(EnumFacingMultiple facing) {
        Rotation result = Rotation.NONE;
        if (facing.getFacings().contains(EnumFacing.SOUTH)) {
            result = Rotation.CLOCKWISE_180;
        } else if (facing.getFacings().contains(EnumFacing.EAST)) {
            result = Rotation.CLOCKWISE_90;
        } else if (facing.getFacings().contains(EnumFacing.WEST)) {
            result = Rotation.COUNTERCLOCKWISE_90;
        }
        return result;
    }

    public static Rotation fromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.CLOCKWISE_180;
            }
            case SOUTH: {
                return Rotation.NONE;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int rotatedMinX(int minX, int width, int length, Rotation rotation) {
        if (RotationHelp.isOddDiffWithNeutral(rotation)) {
            return minX + width / 2 - length / 2;
        }
        return minX;
    }

    public static int rotatedMinZ(int minZ, int width, int length, Rotation rotation) {
        if (RotationHelp.isOddDiffWithNeutral(rotation)) {
            return minZ + length / 2 - width / 2;
        }
        return minZ;
    }

    public static int getWidth(IDimensions dimensions, Rotation rotation) {
        if (RotationHelp.isOddDiffWithNeutral(rotation)) {
            return dimensions.getLength();
        }
        return dimensions.getWidth();
    }

    public static int getLength(IDimensions dimensions, Rotation rotation) {
        if (RotationHelp.isOddDiffWithNeutral(rotation)) {
            return dimensions.getWidth();
        }
        return dimensions.getLength();
    }

    public static int getWidth(int width, int length, Rotation rotation) {
        if (RotationHelp.isOddDiffWithNeutral(rotation)) {
            return length;
        }
        return width;
    }

    public static int getLength(int width, int length, Rotation rotation) {
        if (RotationHelp.isOddDiffWithNeutral(rotation)) {
            return width;
        }
        return length;
    }

    public static BlockPos getMax(BlockPos min, int width, int height, int length, Rotation rotation) {
        return RegionHelp.getMax(min, RotationHelp.getWidth(width, length, rotation), height, RotationHelp.getLength(width, length, rotation));
    }

    public static BlockPos getMax(BlockPos min, IDimensions dimensions, Rotation rotation) {
        return RotationHelp.getMax(min, dimensions.getWidth(), dimensions.getHeight(), dimensions.getLength(), rotation);
    }

    private static int indexDifference(Rotation rot1, Rotation rot2) {
        return rot1.ordinal() - rot2.ordinal();
    }

    public static int getRotationAmount(Rotation rot1, Rotation rot2) {
        int rotationAmount = RotationHelp.indexDifference(rot1, rot2);
        if (rotationAmount == 3 || rotationAmount == -3) {
            return 1;
        }
        return rotationAmount;
    }

    public static Rotation getRotationDifference(Rotation rot1, Rotation rot2) {
        switch (rot1) {
            case NONE: {
                return rot2;
            }
            case CLOCKWISE_90: {
                switch (rot2) {
                    case NONE: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_180: {
                        return Rotation.CLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return Rotation.CLOCKWISE_180;
                    }
                    case CLOCKWISE_90: {
                        return Rotation.NONE;
                    }
                }
            }
            case CLOCKWISE_180: {
                switch (rot2) {
                    case NONE: {
                        return Rotation.CLOCKWISE_180;
                    }
                    case CLOCKWISE_90: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return Rotation.CLOCKWISE_90;
                    }
                    case CLOCKWISE_180: {
                        return Rotation.NONE;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (rot2) {
                    case NONE: {
                        return Rotation.CLOCKWISE_90;
                    }
                    case CLOCKWISE_180: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return Rotation.CLOCKWISE_180;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return Rotation.NONE;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isOddDiffWithNeutral(Rotation rot) {
        return Math.abs(RotationHelp.getRotationAmount(rot, Rotation.NONE)) == 1;
    }

    public static Rotation getNextRotation(Rotation rotation, boolean clockwise) {
        int newIndex = rotation.ordinal() + (clockwise ? 1 : -1);
        if (newIndex < 0) {
            newIndex = Rotation.values().length - 1;
        } else if (newIndex == Rotation.values().length) {
            newIndex = 0;
        }
        return Rotation.values()[newIndex];
    }

    public static boolean getGoClockwise(Rotation rot1, Rotation rot2) {
        boolean clockwise;
        int rotationAmount = RotationHelp.indexDifference(rot1, rot2);
        boolean bl = clockwise = rotationAmount > 0;
        if (rotationAmount == 3) {
            return false;
        }
        if (rotationAmount == -3) {
            return true;
        }
        return clockwise;
    }
}

