/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.cache;

import com.gildedgames.orbis.lib.util.cache.NotPersistedException;
import com.gildedgames.orbis.lib.util.cache.RemovalNotifications;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractPersistingCache<K, V>
implements Cache<K, V> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractPersistingCache.class);
    private final LoadingCache<K, V> underlyingCache;
    private final RemovalListener<K, V> removalListener;

    protected AbstractPersistingCache(CacheBuilder<Object, Object> cacheBuilder) {
        this(cacheBuilder, null);
    }

    protected AbstractPersistingCache(CacheBuilder<Object, Object> cacheBuilder, RemovalListener<K, V> removalListener) {
        this.underlyingCache = this.makeCache(cacheBuilder);
        this.removalListener = removalListener;
    }

    private LoadingCache<K, V> makeCache(CacheBuilder<Object, Object> cacheBuilder) {
        return cacheBuilder.removalListener((RemovalListener)new PersistingRemovalListener()).build((CacheLoader)new PersistedStateCacheLoader());
    }

    protected boolean isPersistenceRelevant(RemovalCause removalCause) {
        return removalCause != RemovalCause.EXPLICIT && removalCause != RemovalCause.REPLACED;
    }

    protected LoadingCache<K, V> getUnderlyingCache() {
        return this.underlyingCache;
    }

    protected abstract V findPersisted(K var1) throws IOException;

    protected abstract void persistValue(K var1, V var2) throws IOException;

    protected abstract List<String> directoryFor(K var1);

    protected abstract void persist(K var1, V var2, OutputStream var3) throws IOException;

    protected abstract V readPersisted(K var1, InputStream var2) throws IOException;

    protected abstract boolean isPersist(K var1);

    protected abstract void deletePersistedIfExistent(K var1);

    protected abstract void deleteAllPersisted();

    protected abstract int sizeOfPersisted();

    public V getIfPresent(Object key) {
        block4: {
            try {
                Object castKey = key;
                return (V)this.underlyingCache.get(castKey);
            }
            catch (ClassCastException e) {
                LOGGER.info(String.format("Could not cast key %s to desired type", key), (Throwable)e);
            }
            catch (ExecutionException e) {
                LOGGER.warn(String.format("Persisted value to key %s could not be retrieved", key), (Throwable)e);
                throw new RuntimeException("Error while loading persisted value", e);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NotPersistedException) break block4;
                throw e;
            }
        }
        return null;
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        return (V)this.underlyingCache.get(key, (Callable)new PersistedStateValueLoader(key, valueLoader));
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        ImmutableMap.Builder allPresent = ImmutableMap.builder();
        for (Object key : keys) {
            V value = this.getIfPresent(key);
            if (value == null) continue;
            allPresent.put(key, value);
        }
        return allPresent.build();
    }

    public void put(K key, V value) {
        this.underlyingCache.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.underlyingCache.putAll(m);
    }

    public void invalidate(Object key) {
        this.underlyingCache.invalidate(key);
        this.invalidatePersisted(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        this.underlyingCache.invalidateAll(keys);
        for (Object key : keys) {
            this.invalidatePersisted(key);
        }
    }

    private void invalidatePersisted(Object key) {
        try {
            Object castKey = key;
            if (this.removalListener == null) {
                this.deletePersistedIfExistent(castKey);
            } else {
                V value = this.findPersisted(castKey);
                if (value != null) {
                    this.removalListener.onRemoval(RemovalNotifications.make(castKey, value));
                    this.deletePersistedIfExistent(castKey);
                }
            }
        }
        catch (ClassCastException e) {
            LOGGER.info(String.format("Could not cast key %s to desired type", key), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void invalidateAll() {
        this.underlyingCache.invalidateAll();
        this.deleteAllPersisted();
    }

    public long size() {
        return this.underlyingCache.size() + (long)this.sizeOfPersisted();
    }

    public CacheStats stats() {
        return this.underlyingCache.stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.underlyingCache.asMap();
    }

    public void cleanUp() {
        this.underlyingCache.cleanUp();
    }

    private class PersistedStateValueLoader
    extends PersistedStateCacheLoader
    implements Callable<V> {
        private final K key;
        private final Callable<? extends V> valueLoader;

        private PersistedStateValueLoader(K key, Callable<? extends V> valueLoader) {
            this.key = key;
            this.valueLoader = valueLoader;
        }

        @Override
        public V call() throws Exception {
            Object value;
            try {
                value = this.load(this.key);
            }
            catch (NotPersistedException e) {
                value = null;
            }
            if (value != null) {
                return value;
            }
            return this.valueLoader.call();
        }
    }

    private class PersistedStateCacheLoader
    extends CacheLoader<K, V> {
        private PersistedStateCacheLoader() {
        }

        public V load(K key) {
            Object value = null;
            try {
                value = AbstractPersistingCache.this.findPersisted(key);
                if (value != null) {
                    AbstractPersistingCache.this.deletePersistedIfExistent(key);
                    AbstractPersistingCache.this.underlyingCache.put(key, value);
                }
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Could not load persisted value to key %s", key), (Throwable)e);
            }
            if (value != null) {
                return value;
            }
            throw new NotPersistedException();
        }
    }

    private class PersistingRemovalListener
    implements RemovalListener<K, V> {
        private PersistingRemovalListener() {
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
            if (AbstractPersistingCache.this.isPersistenceRelevant(notification.getCause())) {
                try {
                    AbstractPersistingCache.this.persistValue(notification.getKey(), notification.getValue());
                }
                catch (IOException e) {
                    LOGGER.warn(String.format("Could not persist value %s to key %s", notification.getKey(), notification.getValue()), (Throwable)e);
                }
            } else if (AbstractPersistingCache.this.removalListener != null) {
                AbstractPersistingCache.this.removalListener.onRemoval(notification);
            }
        }
    }
}

