/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.cache;

import com.gildedgames.orbis.lib.util.cache.FileSystemLoadingPersistingCache;
import com.gildedgames.orbis.lib.util.cache.FileSystemPersistingCache;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.Weigher;
import java.io.File;
import java.util.concurrent.TimeUnit;

public final class FileSystemCacheBuilder<K, V> {
    private final CacheBuilder<Object, Object> underlyingCacheBuilder;
    private RemovalListener<? super K, ? super V> removalListener;
    private File persistenceDirectory;

    private FileSystemCacheBuilder() {
        this.underlyingCacheBuilder = CacheBuilder.newBuilder();
    }

    private FileSystemCacheBuilder(CacheBuilder<Object, Object> cacheBuilder) {
        this.underlyingCacheBuilder = cacheBuilder;
    }

    public static FileSystemCacheBuilder<Object, Object> from(CacheBuilderSpec spec) {
        return new FileSystemCacheBuilder<Object, Object>((CacheBuilder<Object, Object>)CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public static FileSystemCacheBuilder<Object, Object> from(String spec) {
        return new FileSystemCacheBuilder<Object, Object>((CacheBuilder<Object, Object>)CacheBuilder.from((String)spec));
    }

    public static FileSystemCacheBuilder<Object, Object> newBuilder() {
        return new FileSystemCacheBuilder<Object, Object>();
    }

    private static <K, V> RemovalListener<K, V> castRemovalListener(RemovalListener<?, ?> removalListener) {
        if (removalListener == null) {
            return null;
        }
        return removalListener;
    }

    public FileSystemCacheBuilder<K, V> concurrencyLevel(int concurrencyLevel) {
        this.underlyingCacheBuilder.concurrencyLevel(concurrencyLevel);
        return this;
    }

    public FileSystemCacheBuilder<K, V> expireAfterAccess(long duration, TimeUnit unit) {
        this.underlyingCacheBuilder.expireAfterWrite(duration, unit);
        return this;
    }

    public FileSystemCacheBuilder<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        this.underlyingCacheBuilder.expireAfterWrite(duration, unit);
        return this;
    }

    public FileSystemCacheBuilder<K, V> refreshAfterWrite(long duration, TimeUnit unit) {
        this.underlyingCacheBuilder.refreshAfterWrite(duration, unit);
        return this;
    }

    public FileSystemCacheBuilder<K, V> initialCapacity(int initialCapacity) {
        this.underlyingCacheBuilder.initialCapacity(initialCapacity);
        return this;
    }

    public FileSystemCacheBuilder<K, V> maximumSize(long size) {
        this.underlyingCacheBuilder.maximumSize(size);
        return this;
    }

    public FileSystemCacheBuilder<K, V> maximumWeight(long weight) {
        this.underlyingCacheBuilder.maximumWeight(weight);
        return this;
    }

    public FileSystemCacheBuilder<K, V> recordStats() {
        this.underlyingCacheBuilder.recordStats();
        return this;
    }

    public FileSystemCacheBuilder<K, V> softValues() {
        this.underlyingCacheBuilder.softValues();
        return this;
    }

    public FileSystemCacheBuilder<K, V> weakKeys() {
        this.underlyingCacheBuilder.weakKeys();
        return this;
    }

    public FileSystemCacheBuilder<K, V> weakValues() {
        this.underlyingCacheBuilder.weakValues();
        return this;
    }

    public FileSystemCacheBuilder<K, V> ticker(Ticker ticker) {
        this.underlyingCacheBuilder.ticker(ticker);
        return this;
    }

    public <K1 extends K, V1 extends V> FileSystemCacheBuilder<K1, V1> weigher(Weigher<? super K1, ? super V1> weigher) {
        this.underlyingCacheBuilder.weigher(weigher);
        return this;
    }

    public <K1 extends K, V1 extends V> FileSystemCacheBuilder<K1, V1> removalListener(RemovalListener<? super K1, ? super V1> listener) {
        Preconditions.checkState((this.removalListener == null ? 1 : 0) != 0);
        FileSystemCacheBuilder castThis = this;
        castThis.removalListener = (RemovalListener)Preconditions.checkNotNull(listener);
        return castThis;
    }

    public FileSystemCacheBuilder<K, V> persistenceDirectory(File persistenceDirectory) {
        Preconditions.checkState((this.persistenceDirectory == null ? 1 : 0) != 0);
        this.persistenceDirectory = (File)Preconditions.checkNotNull((Object)persistenceDirectory);
        return this;
    }

    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        if (this.persistenceDirectory == null) {
            return new FileSystemPersistingCache<K, V>(this.underlyingCacheBuilder, FileSystemCacheBuilder.castRemovalListener(this.removalListener));
        }
        return new FileSystemPersistingCache<K, V>(this.underlyingCacheBuilder, this.persistenceDirectory, FileSystemCacheBuilder.castRemovalListener(this.removalListener));
    }

    public <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(CacheLoader<? super K1, V1> loader) {
        if (this.persistenceDirectory == null) {
            return new FileSystemLoadingPersistingCache<K1, V1>(this.underlyingCacheBuilder, loader, FileSystemCacheBuilder.castRemovalListener(this.removalListener));
        }
        return new FileSystemLoadingPersistingCache<K1, V1>(this.underlyingCacheBuilder, loader, this.persistenceDirectory, FileSystemCacheBuilder.castRemovalListener(this.removalListener));
    }

    public String toString() {
        return "FileSystemCacheBuilder{underlyingCacheBuilder=" + this.underlyingCacheBuilder + ", persistenceDirectory=" + this.persistenceDirectory + '}';
    }
}

