/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.cache;

import com.gildedgames.orbis.lib.util.cache.AbstractPersistingCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileSystemPersistingCache<K, V>
extends AbstractPersistingCache<K, V> {
    private static final Logger LOGGER = LogManager.getLogger(FileSystemPersistingCache.class);
    private final File persistenceRootDirectory;

    protected FileSystemPersistingCache(CacheBuilder<Object, Object> cacheBuilder) {
        this(cacheBuilder, Files.createTempDir());
    }

    protected FileSystemPersistingCache(CacheBuilder<Object, Object> cacheBuilder, File persistenceDirectory) {
        this(cacheBuilder, persistenceDirectory, null);
    }

    protected FileSystemPersistingCache(CacheBuilder<Object, Object> cacheBuilder, RemovalListener<K, V> removalListener) {
        this(cacheBuilder, Files.createTempDir(), removalListener);
    }

    protected FileSystemPersistingCache(CacheBuilder<Object, Object> cacheBuilder, File persistenceDirectory, RemovalListener<K, V> removalListener) {
        super(cacheBuilder, removalListener);
        this.persistenceRootDirectory = this.validateDirectory(persistenceDirectory);
        LOGGER.info("Persisting to {}", (Object)persistenceDirectory.getAbsolutePath());
    }

    private File validateDirectory(File directory) {
        directory.mkdirs();
        if (!(directory.exists() && directory.isDirectory() && directory.canRead() && directory.canWrite())) {
            throw new IllegalArgumentException(String.format("Directory %s cannot be used as a persistence directory", directory.getAbsolutePath()));
        }
        return directory;
    }

    private File pathToFileFor(K key) {
        List<String> pathSegments = this.directoryFor(key);
        File persistenceFile = this.persistenceRootDirectory;
        for (String pathSegment : pathSegments) {
            persistenceFile = new File(persistenceFile, pathSegment);
        }
        if (this.persistenceRootDirectory.equals(persistenceFile) || persistenceFile.isDirectory()) {
            throw new IllegalArgumentException();
        }
        return persistenceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected V findPersisted(K key) {
        if (!this.isPersist(key)) {
            return null;
        }
        File persistenceFile = this.pathToFileFor(key);
        if (!persistenceFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            try (FileInputStream fileInputStream = new FileInputStream(persistenceFile);){
                V v;
                FileLock fileLock = fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
                try {
                    v = this.readPersisted(key, fileInputStream);
                }
                catch (Throwable throwable2) {
                    try {
                        fileLock.release();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                fileLock.release();
                return v;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void persistValue(K key, V value) throws IOException {
        if (!this.isPersist(key)) {
            return;
        }
        File persistenceFile = this.pathToFileFor(key);
        persistenceFile.getParentFile().mkdirs();
        try (FileOutputStream fileOutputStream = new FileOutputStream(persistenceFile);){
            FileLock fileLock = fileOutputStream.getChannel().lock();
            try {
                this.persist(key, value, fileOutputStream);
            }
            finally {
                fileLock.release();
            }
        }
    }

    @Override
    protected void persist(K key, V value, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
    }

    @Override
    protected boolean isPersist(K key) {
        return true;
    }

    @Override
    protected List<String> directoryFor(K key) {
        return Arrays.asList(key.toString());
    }

    @Override
    protected V readPersisted(K key, InputStream inputStream) throws IOException {
        try {
            return (V)new ObjectInputStream(inputStream).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Serialized version assigned by %s was invalid", key), e);
        }
    }

    @Override
    protected void deletePersistedIfExistent(K key) {
        File file = this.pathToFileFor(key);
        file.delete();
    }

    @Override
    protected void deleteAllPersisted() {
        for (File file : this.persistenceRootDirectory.listFiles()) {
            file.delete();
        }
    }

    @Override
    protected int sizeOfPersisted() {
        return this.countFilesInFolders(this.persistenceRootDirectory);
    }

    private int countFilesInFolders(File directory) {
        int size = 0;
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                size += this.countFilesInFolders(file);
                continue;
            }
            if (file.getName().startsWith(".")) continue;
            ++size;
        }
        return size;
    }

    public File getPersistenceRootDirectory() {
        return this.persistenceRootDirectory;
    }
}

