/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.cache;

import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RemovalNotifications {
    private static final Logger LOGGER = LogManager.getLogger(RemovalNotifications.class);
    private static RemovalNotifications INSTANCE;
    private final Constructor<RemovalNotification> constructor;

    private RemovalNotifications() {
        try {
            this.constructor = RemovalNotification.class.getDeclaredConstructor(Object.class, Object.class, RemovalCause.class);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            String message = String.format("Could not find known constructor for %s", RemovalNotification.class.getCanonicalName());
            LOGGER.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RemovalNotifications getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<RemovalNotifications> clazz = RemovalNotifications.class;
        synchronized (RemovalNotifications.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new RemovalNotifications();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static <K, V> RemovalNotification<K, V> make(K key, V value) {
        return RemovalNotifications.getInstance().makeInternal(key, value);
    }

    private <K, V> RemovalNotification<K, V> makeInternal(K key, V value) {
        try {
            try {
                return this.constructor.newInstance(key, value, RemovalCause.EXPLICIT);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(String.format("Creating an instance of %s for key %s and value %s caused an exception to be thrown", RemovalNotification.class.getCanonicalName(), key, value), e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(String.format("Could not call %s's constructor for key %s and value %s", RemovalNotification.class.getCanonicalName(), key, value), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Could not access %s's constructor for key %s and value %s", RemovalNotification.class.getCanonicalName(), key, value), e);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

