/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.io;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import net.minecraft.world.World;

public class Instantiator<T>
implements Function<World, T> {
    private final Class<T> clazz;
    private Constructor<T> emptyConstructor;
    private Constructor<T> worldConstructor;

    public Instantiator(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T apply(World world) {
        try {
            Constructor<T> constructor;
            if (world == null) {
                if (this.emptyConstructor == null) {
                    try {
                        this.emptyConstructor = this.clazz.getDeclaredConstructor(new Class[0]);
                        this.emptyConstructor.setAccessible(true);
                    }
                    catch (NoSuchMethodException e) {
                        throw new NullPointerException("Couldn't find public constructor()" + this.clazz.getName());
                    }
                }
                constructor = this.emptyConstructor;
            } else {
                if (this.worldConstructor == null) {
                    try {
                        this.worldConstructor = this.clazz.getDeclaredConstructor(World.class);
                        this.worldConstructor.setAccessible(true);
                    }
                    catch (NoSuchMethodException e) {
                        throw new NullPointerException("Couldn't find public constructor(World) for " + this.clazz.getName());
                    }
                }
                constructor = this.worldConstructor;
            }
            return world != null ? constructor.newInstance(world) : constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

