/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.io;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.Array;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class NBTFunnel {
    public static Function<IBlockState, NBTTagCompound> BLOCKSTATE_SETTER = state -> {
        NBTTagCompound t = new NBTTagCompound();
        ResourceLocation identifier = OrbisLib.services().registrar().getIdentifierFor(state.func_177230_c());
        short meta = (short)state.func_177230_c().func_176201_c(state);
        t.func_74778_a("mod", identifier.func_110624_b());
        t.func_74778_a("name", identifier.func_110623_a());
        t.func_74777_a("meta", meta);
        return t;
    };
    public static Function<NBTTagCompound, IBlockState> BLOCKSTATE_GETTER = tag -> {
        String mod = tag.func_74779_i("mod");
        String name = tag.func_74779_i("name");
        Block block = OrbisLib.services().registrar().findBlock(new ResourceLocation(mod, name));
        short meta = tag.func_74765_d("meta");
        return block.func_176203_a((int)meta);
    };
    public static Function<ItemStack, NBTTagCompound> STACK_SETTER = o -> {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("s", NBTHelper.writeStack(o));
        return tag;
    };
    public static Function<NBTTagCompound, ItemStack> STACK_GETTER = n -> NBTHelper.readStack(n.func_74775_l("s"));
    public static Function<UUID, NBTTagCompound> UUID_SETTER = o -> {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("u", o);
        return tag;
    };
    public static Function<NBTTagCompound, UUID> UUID_GETTER = n -> n.func_186857_a("u");
    public static Function<ResourceLocation, NBTTagCompound> RESOURCE_SETTER = o -> {
        NBTTagCompound f = new NBTTagCompound();
        f.func_74778_a("s", o.toString());
        return f;
    };
    public static Function<NBTTagCompound, ResourceLocation> RESOURCE_GETTER = n -> new ResourceLocation(n.func_74779_i("s"));
    public static Function<String, NBTTagCompound> STRING_SETTER = o -> {
        NBTTagCompound f = new NBTTagCompound();
        f.func_74778_a("s", o);
        return f;
    };
    public static Function<NBTTagCompound, String> STRING_GETTER = n -> n.func_74779_i("s");
    public static Function<Boolean, NBTTagCompound> BOOLEAN_SETTER = o -> {
        NBTTagCompound f = new NBTTagCompound();
        f.func_74757_a("b", o.booleanValue());
        return f;
    };
    public static Function<NBTTagCompound, Boolean> BOOLEAN_GETTER = n -> n.func_74767_n("b");
    public static Function<Integer, NBTTagCompound> INTEGER_SETTER = o -> {
        NBTTagCompound f = new NBTTagCompound();
        f.func_74768_a("i", o.intValue());
        return f;
    };
    public static Function<NBTTagCompound, Integer> INTEGER_GETTER = n -> n.func_74762_e("i");
    public static Function<ResourceLocation, NBTTagCompound> LOC_SETTER = o -> {
        NBTTagCompound f = new NBTTagCompound();
        f.func_74778_a("loc", o.toString());
        return f;
    };
    public static Function<NBTTagCompound, ResourceLocation> LOC_GETTER = n -> new ResourceLocation(n.func_74779_i("loc"));
    public static Function<BlockPos, NBTTagCompound> POS_SETTER = o -> {
        NBTFunnel f = new NBTFunnel(new NBTTagCompound());
        f.setPos("p", (BlockPos)o);
        return f.getTag();
    };
    public static Function<NBTTagCompound, BlockPos> POS_GETTER = n -> {
        NBTFunnel f = new NBTFunnel((NBTTagCompound)n);
        return f.getPos("p");
    };
    public static Function<Pos2D, NBTTagCompound> POS2D_SETTER = o -> {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("x", o.x());
        tag.func_74776_a("y", o.y());
        return tag;
    };
    public static Function<NBTTagCompound, Pos2D> POS2D_GETTER = n -> Pos2D.flush(n.func_74760_g("x"), n.func_74760_g("y"));
    public static Function<ChunkPos, NBTTagCompound> CHUNK_POS_SETTER = o -> {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", o.field_77276_a);
        tag.func_74768_a("z", o.field_77275_b);
        return tag;
    };
    public static Function<NBTTagCompound, ChunkPos> CHUNK_POS_GETTER = n -> new ChunkPos(n.func_74762_e("x"), n.func_74762_e("z"));
    private final NBTTagCompound tag;

    public NBTFunnel(NBTTagCompound tag) {
        this.tag = tag;
    }

    public static <T extends NBT> Function<NBTTagCompound, T> getter() {
        return n -> {
            NBTFunnel funnel = new NBTFunnel((NBTTagCompound)n);
            return funnel.get("o");
        };
    }

    public static <T extends NBT> Function<T, NBTTagCompound> setter() {
        return o -> {
            NBTTagCompound tag = new NBTTagCompound();
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.set("o", (NBT)o);
            return tag;
        };
    }

    public static <T extends List<? extends NBT>> Function<NBTTagCompound, T> listGetter() {
        return n -> {
            NBTFunnel funnel = new NBTFunnel((NBTTagCompound)n);
            return funnel.getList("l");
        };
    }

    public static <T extends List<? extends NBT>> Function<T, NBTTagCompound> listSetter() {
        return l -> {
            NBTTagCompound tag = new NBTTagCompound();
            NBTFunnel funnel = new NBTFunnel(tag);
            funnel.setList("l", (List<? extends NBT>)l);
            return tag;
        };
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    public void setStack(String key, ItemStack stack) {
        this.tag.func_74782_a(key, NBTHelper.writeStack(stack));
    }

    public ItemStack getStack(String key) {
        return NBTHelper.readStack(this.tag.func_74775_l(key));
    }

    public void set(String key, NBT nbt) {
        this.tag.func_74782_a(key, (NBTBase)NBTHelper.write(nbt));
    }

    public LocalDateTime getDate(String key) {
        NBTTagCompound tag = this.tag.func_74775_l(key);
        if (tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return null;
        }
        return LocalDateTime.parse(tag.func_74779_i("date"));
    }

    public void setDate(String key, LocalDateTime date) {
        NBTTagCompound tag = new NBTTagCompound();
        if (date == null) {
            tag.func_74757_a("_null", true);
            return;
        }
        tag.func_74757_a("_null", false);
        tag.func_74778_a("date", date.toString());
        this.tag.func_74782_a(key, (NBTBase)tag);
    }

    public <NBT_OBJECT> void setSet(String key, Set<NBT_OBJECT> nbtList, @Nullable Function<NBT_OBJECT, NBTTagCompound> setter) {
        NBTTagList writtenObjects = new NBTTagList();
        for (NBT_OBJECT nbt : nbtList) {
            if (setter != null) {
                writtenObjects.func_74742_a((NBTBase)setter.apply(nbt));
                continue;
            }
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write((NBT)nbt));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <NBT_OBJECT> Set<NBT_OBJECT> getSet(String key, @Nullable Function<NBTTagCompound, NBT_OBJECT> getter) {
        HashSet readObjects = Sets.newHashSet();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            readObjects.add(getter != null ? getter.apply(data) : NBTHelper.read(data));
        }
        return readObjects;
    }

    public <NBT_OBJECT> void set(String key, NBT_OBJECT nbt, @Nullable Function<NBT_OBJECT, NBTTagCompound> setter) {
        NBTTagCompound tag = new NBTTagCompound();
        if (nbt == null) {
            tag.func_74757_a("_null", true);
        } else {
            tag.func_74757_a("_null", false);
            if (setter != null) {
                tag.func_74782_a("data", (NBTBase)setter.apply(nbt));
            } else {
                tag.func_74782_a("data", (NBTBase)NBTHelper.write((NBT)nbt));
            }
        }
        this.tag.func_74782_a(key, (NBTBase)tag);
    }

    public <NBT_OBJECT> NBT_OBJECT get(String key, @Nullable Function<NBTTagCompound, NBT_OBJECT> getter) {
        NBTTagCompound tag = this.tag.func_74775_l(key);
        if (tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return null;
        }
        NBTTagCompound data = tag.func_74775_l("data");
        return (NBT_OBJECT)(getter != null ? getter.apply(data) : NBTHelper.read(data));
    }

    public <NBT_OBJECT> NBT_OBJECT getWithDefault(String key, @Nullable Function<NBTTagCompound, NBT_OBJECT> getter, Supplier<NBT_OBJECT> def) {
        NBTTagCompound tag = this.tag.func_74775_l(key);
        if (tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return def.get();
        }
        NBTTagCompound data = tag.func_74775_l("data");
        return (NBT_OBJECT)(getter != null ? getter.apply(data) : NBTHelper.read(data));
    }

    public <T extends NBT> T get(String key) {
        return NBTHelper.read(this.tag.func_74775_l(key));
    }

    public <T extends NBT> T getWithDefault(String key, Supplier<T> def) {
        return NBTHelper.readWithDefault(this.tag.func_74775_l(key), def);
    }

    public <T extends NBT> T get(World world, String key) {
        return NBTHelper.read(world, this.tag.func_74775_l(key));
    }

    public <T extends NBT> T getWithDefault(World world, String key, Supplier<T> def) {
        return NBTHelper.readWithDefault(world, this.tag.func_74775_l(key), def);
    }

    public void setPos(String key, BlockPos pos) {
        this.tag.func_74782_a(key, NBTHelper.writeBlockPos(pos));
    }

    public BlockPos getPos(String key) {
        return NBTHelper.readBlockPos(this.tag.func_74775_l(key));
    }

    public void setIntToStringMap(String key, Map<Integer, String> nbtMap) {
        NBTTagList writtenKeys = new NBTTagList();
        NBTTagList writtenObjects = new NBTTagList();
        for (Map.Entry<Integer, String> entrySet : nbtMap.entrySet()) {
            int intKey = entrySet.getKey();
            String string = entrySet.getValue();
            writtenKeys.func_74742_a((NBTBase)new NBTTagInt(intKey));
            writtenObjects.func_74742_a((NBTBase)new NBTTagString(string));
        }
        this.tag.func_74782_a(key + "_keys", (NBTBase)writtenKeys);
        this.tag.func_74782_a(key + "_obj", (NBTBase)writtenObjects);
    }

    public Map<Integer, String> getIntToStringMap(String key) {
        HashMap readObjects = Maps.newHashMap();
        NBTTagList keys = this.tag.func_150295_c(key + "_keys", 3);
        NBTTagList objects = this.tag.func_150295_c(key + "_obj", 8);
        for (int i = 0; i < keys.func_74745_c(); ++i) {
            int intKey = keys.func_186858_c(i);
            String data = objects.func_150307_f(i);
            readObjects.put(intKey, data);
        }
        return readObjects;
    }

    private <T extends NBT> Map<String, T> getStringMapInner(World world, String key) {
        HashMap readObjects = Maps.newHashMap();
        NBTTagList keys = this.tag.func_150295_c(key + "_keys", 8);
        NBTTagList objects = this.tag.func_150295_c(key + "_obj", 10);
        for (int i = 0; i < keys.func_74745_c(); ++i) {
            String stringKey = keys.func_150307_f(i);
            NBTTagCompound data = objects.func_150305_b(i);
            readObjects.put(stringKey, world == null ? NBTHelper.read(data) : NBTHelper.read(world, data));
        }
        return readObjects;
    }

    public <T extends NBT> Map<String, T> getStringMap(String key) {
        return this.getStringMapInner(null, key);
    }

    public <T extends NBT> Map<String, T> getStringMap(World world, String key) {
        return this.getStringMapInner(world, key);
    }

    public void setMap(String key, Map<? extends NBT, ? extends NBT> nbtMap) {
        NBTTagList writtenKeys = new NBTTagList();
        NBTTagList writtenObjects = new NBTTagList();
        for (Map.Entry<? extends NBT, ? extends NBT> entrySet : nbtMap.entrySet()) {
            NBT keyNBT = entrySet.getKey();
            NBT valueNBT = entrySet.getValue();
            writtenKeys.func_74742_a((NBTBase)NBTHelper.write(keyNBT));
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write(valueNBT));
        }
        this.tag.func_74782_a(key + "_keys", (NBTBase)writtenKeys);
        this.tag.func_74782_a(key + "_obj", (NBTBase)writtenObjects);
    }

    public <R> void setLongMap(String key, Long2ObjectOpenHashMap<R> nbtMap, @Nullable Function<R, NBTTagCompound> rightSetter) {
        NBTTagList writtenKeys = new NBTTagList();
        NBTTagList writtenObjects = new NBTTagList();
        nbtMap.long2ObjectEntrySet().forEach(entry -> {
            long chunkPos = entry.getLongKey();
            Object valueNBT = entry.getValue();
            writtenKeys.func_74742_a((NBTBase)new NBTTagLong(chunkPos));
            if (rightSetter != null) {
                writtenObjects.func_74742_a((NBTBase)rightSetter.apply(valueNBT));
            } else {
                writtenObjects.func_74742_a((NBTBase)NBTHelper.write((NBT)valueNBT));
            }
        });
        this.tag.func_74782_a(key + "_keys", (NBTBase)writtenKeys);
        this.tag.func_74782_a(key + "_obj", (NBTBase)writtenObjects);
    }

    public <R> Long2ObjectOpenHashMap<R> getLongMap(String key, @Nullable Function<NBTTagCompound, R> rightGetter) {
        Long2ObjectOpenHashMap readObjects = new Long2ObjectOpenHashMap();
        NBTTagList keys = this.tag.func_150295_c(key + "_keys", 4);
        NBTTagList objects = this.tag.func_150295_c(key + "_obj", 10);
        for (int i = 0; i < keys.func_74745_c(); ++i) {
            NBTTagLong keyData = (NBTTagLong)keys.func_179238_g(i);
            NBTTagCompound valueData = objects.func_150305_b(i);
            readObjects.put(keyData.func_150291_c(), rightGetter != null ? rightGetter.apply(valueData) : NBTHelper.read(valueData));
        }
        return readObjects;
    }

    public <L, R> void setMap(String key, Map<L, R> nbtMap, @Nullable Function<L, NBTTagCompound> leftSetter, @Nullable Function<R, NBTTagCompound> rightSetter) {
        NBTTagList writtenKeys = new NBTTagList();
        NBTTagList writtenObjects = new NBTTagList();
        for (Map.Entry<L, R> entrySet : nbtMap.entrySet()) {
            L keyNBT = entrySet.getKey();
            R valueNBT = entrySet.getValue();
            if (leftSetter != null) {
                writtenKeys.func_74742_a((NBTBase)leftSetter.apply(keyNBT));
            } else {
                writtenKeys.func_74742_a((NBTBase)NBTHelper.write((NBT)keyNBT));
            }
            if (rightSetter != null) {
                writtenObjects.func_74742_a((NBTBase)rightSetter.apply(valueNBT));
                continue;
            }
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write((NBT)valueNBT));
        }
        this.tag.func_74782_a(key + "_keys", (NBTBase)writtenKeys);
        this.tag.func_74782_a(key + "_obj", (NBTBase)writtenObjects);
    }

    public <L, R> Map<L, R> getMap(String key, @Nullable Function<NBTTagCompound, L> leftGetter, @Nullable Function<NBTTagCompound, R> rightGetter) {
        HashMap readObjects = Maps.newHashMap();
        NBTTagList keys = this.tag.func_150295_c(key + "_keys", 10);
        NBTTagList objects = this.tag.func_150295_c(key + "_obj", 10);
        for (int i = 0; i < keys.func_74745_c(); ++i) {
            NBTTagCompound keyData = keys.func_150305_b(i);
            NBTTagCompound valueData = objects.func_150305_b(i);
            readObjects.put(leftGetter != null ? leftGetter.apply(keyData) : NBTHelper.read(keyData), rightGetter != null ? rightGetter.apply(valueData) : NBTHelper.read(valueData));
        }
        return readObjects;
    }

    private <K extends NBT, T extends NBT> Map<K, T> getMapInner(World world, String key) {
        HashMap readObjects = Maps.newHashMap();
        NBTTagList keys = this.tag.func_150295_c(key + "_keys", 10);
        NBTTagList objects = this.tag.func_150295_c(key + "_obj", 10);
        for (int i = 0; i < keys.func_74745_c(); ++i) {
            NBTTagCompound keyData = keys.func_150305_b(i);
            NBTTagCompound valueData = objects.func_150305_b(i);
            readObjects.put(world == null ? NBTHelper.read(keyData) : NBTHelper.read(world, keyData), world == null ? NBTHelper.read(valueData) : NBTHelper.read(world, valueData));
        }
        return readObjects;
    }

    public <K extends NBT, T extends NBT> Map<K, T> getMap(String key) {
        return this.getMapInner(null, key);
    }

    public <K extends NBT, T extends NBT> Map<K, T> getMap(World world, String key) {
        return this.getMapInner(world, key);
    }

    public void setStringMap(String key, Map<String, ? extends NBT> nbtMap) {
        NBTTagList writtenKeys = new NBTTagList();
        NBTTagList writtenObjects = new NBTTagList();
        for (Map.Entry<String, ? extends NBT> entrySet : nbtMap.entrySet()) {
            String stringKey = entrySet.getKey();
            NBT nbt = entrySet.getValue();
            writtenKeys.func_74742_a((NBTBase)new NBTTagString(stringKey));
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write(nbt));
        }
        this.tag.func_74782_a(key + "_keys", (NBTBase)writtenKeys);
        this.tag.func_74782_a(key + "_obj", (NBTBase)writtenObjects);
    }

    public void setIntMap(String key, Map<Integer, ? extends NBT> nbtMap) {
        NBTTagList writtenKeys = new NBTTagList();
        NBTTagList writtenObjects = new NBTTagList();
        for (Map.Entry<Integer, ? extends NBT> entrySet : nbtMap.entrySet()) {
            int intKey = entrySet.getKey();
            NBT nbt = entrySet.getValue();
            writtenKeys.func_74742_a((NBTBase)new NBTTagInt(intKey));
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write(nbt));
        }
        this.tag.func_74782_a(key + "_keys", (NBTBase)writtenKeys);
        this.tag.func_74782_a(key + "_obj", (NBTBase)writtenObjects);
    }

    private <T extends NBT> Map<Integer, T> getIntMapInner(World world, String key) {
        HashMap readObjects = Maps.newHashMap();
        NBTTagList keys = this.tag.func_150295_c(key + "_keys", 3);
        NBTTagList objects = this.tag.func_150295_c(key + "_obj", 10);
        for (int i = 0; i < keys.func_74745_c(); ++i) {
            int intKey = keys.func_186858_c(i);
            NBTTagCompound data = objects.func_150305_b(i);
            readObjects.put(intKey, world == null ? NBTHelper.read(data) : NBTHelper.read(world, data));
        }
        return readObjects;
    }

    public <T extends NBT> Map<Integer, T> getIntMap(String key) {
        return this.getIntMapInner(null, key);
    }

    public <T extends NBT> Map<Integer, T> getIntMap(World world, String key) {
        return this.getIntMapInner(world, key);
    }

    public void setPairList(String key, List<? extends Pair<? extends NBT, ? extends NBT>> nbtList) {
        NBTTagList writtenObjects = new NBTTagList();
        for (Pair<? extends NBT, ? extends NBT> pair : nbtList) {
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write((NBT)pair.getLeft()));
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write((NBT)pair.getRight()));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <T extends Pair, L extends NBT, R extends NBT> List<T> getPairList(World world, String key) {
        ArrayList readObjects = Lists.newArrayList();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound leftData = nbtList.func_150305_b(i);
            NBTTagCompound rightData = nbtList.func_150305_b(i++);
            Object left = NBTHelper.read(world, leftData);
            Object right = NBTHelper.read(world, rightData);
            readObjects.add(Pair.of(left, right));
        }
        return readObjects;
    }

    public <T extends Pair, L extends NBT, R extends NBT> List<T> getPairList(String key) {
        ArrayList readObjects = Lists.newArrayList();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound leftData = nbtList.func_150305_b(i);
            NBTTagCompound rightData = nbtList.func_150305_b(++i);
            Object left = NBTHelper.read(leftData);
            Object right = NBTHelper.read(rightData);
            readObjects.add(Pair.of(left, right));
        }
        return readObjects;
    }

    public void setSet(String key, Set<? extends NBT> nbtList) {
        NBTTagList writtenObjects = new NBTTagList();
        for (NBT nBT : nbtList) {
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write(nBT));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <T extends NBT> Set<T> getSet(World world, String key) {
        HashSet readObjects = Sets.newHashSet();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            readObjects.add(NBTHelper.read(world, data));
        }
        return readObjects;
    }

    public <T extends NBT> Set<T> getSet(String key) {
        HashSet readObjects = Sets.newHashSet();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            readObjects.add(NBTHelper.read(data));
        }
        return readObjects;
    }

    public void setStackList(String key, List<ItemStack> stackList) {
        NBTTagList writtenObjects = new NBTTagList();
        for (ItemStack stack : stackList) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77955_b(tag);
            writtenObjects.func_74742_a((NBTBase)tag);
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public List<ItemStack> getStackList(String key) {
        ArrayList readObjects = Lists.newArrayList();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            readObjects.add(new ItemStack(data));
        }
        return readObjects;
    }

    public <NBT_OBJECT> void setList(String key, List<NBT_OBJECT> nbtList, @Nullable Function<NBT_OBJECT, NBTTagCompound> setter) {
        NBTTagList writtenObjects = new NBTTagList();
        for (NBT_OBJECT nbt : nbtList) {
            if (setter != null) {
                writtenObjects.func_74742_a((NBTBase)setter.apply(nbt));
                continue;
            }
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write((NBT)nbt));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <NBT_OBJECT> void setArray(String key, NBT_OBJECT[] array, @Nullable Function<NBT_OBJECT, NBTTagCompound> setter) {
        boolean nul = array == null;
        this.tag.func_74757_a(key + "_null", nul);
        if (nul) {
            return;
        }
        NBTTagList writtenObjects = new NBTTagList();
        for (NBT_OBJECT obj : array) {
            if (setter != null) {
                writtenObjects.func_74742_a((NBTBase)setter.apply(obj));
                continue;
            }
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write((NBT)obj));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <NBT_OBJECT> NBT_OBJECT[] getArray(String key, Class<? extends NBT_OBJECT> clazz, @Nullable Function<NBTTagCompound, NBT_OBJECT> getter) {
        if (this.tag.func_74767_n(key + "_null")) {
            return null;
        }
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        Object[] readObjects = (Object[])Array.newInstance(clazz, nbtList.func_74745_c());
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            readObjects[i] = getter != null ? getter.apply(nbtList.func_150305_b(i)) : NBTHelper.read(nbtList.func_150305_b(i));
        }
        return readObjects;
    }

    public <NBT_OBJECT> List<NBT_OBJECT> getList(String key, @Nullable Function<NBTTagCompound, NBT_OBJECT> getter) {
        ArrayList readObjects = Lists.newArrayList();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            readObjects.add(getter != null ? getter.apply(data) : NBTHelper.read(data));
        }
        return readObjects;
    }

    public void setList(String key, List<? extends NBT> nbtList) {
        NBTTagList writtenObjects = new NBTTagList();
        for (NBT nBT : nbtList) {
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write(nBT));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <T extends NBT> List<T> getList(World world, String key) {
        ArrayList readObjects = Lists.newArrayList();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            readObjects.add(NBTHelper.read(world, data));
        }
        return readObjects;
    }

    public <T extends NBT> List<T> getList(String key) {
        ArrayList readObjects = Lists.newArrayList();
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            readObjects.add(NBTHelper.read(data));
        }
        return readObjects;
    }

    public List<String> getStringList(String key) {
        ArrayList readObjects = Lists.newArrayList();
        NBTTagList nbtList = this.tag.func_150295_c(key, 8);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            readObjects.add(nbtList.func_150307_f(i));
        }
        return readObjects;
    }

    public void setStringList(String key, List<String> stringList) {
        NBTTagList writtenObjects = new NBTTagList();
        for (String string : stringList) {
            writtenObjects.func_74742_a((NBTBase)new NBTTagString(string));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public void setBooleanArray(String key, boolean[] array) {
        NBTTagList writtenObjects = new NBTTagList();
        for (boolean bool : array) {
            writtenObjects.func_74742_a((NBTBase)new NBTTagByte((byte)(bool ? 1 : 0)));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public boolean[] getBooleanArray(String key) {
        NBTTagList nbtList = this.tag.func_150295_c(key, 1);
        boolean[] readObjects = new boolean[nbtList.func_74745_c()];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            readObjects[i] = ((NBTTagByte)nbtList.func_179238_g(i)).func_150290_f() == 1;
        }
        return readObjects;
    }

    public <T extends IStringSerializable> void setStringSerializeArray(String key, T[] array) {
        boolean nul = array == null;
        this.tag.func_74757_a(key + "_null", nul);
        if (nul) {
            return;
        }
        NBTTagList writtenObjects = new NBTTagList();
        for (T obj : array) {
            writtenObjects.func_74742_a((NBTBase)new NBTTagString(obj.func_176610_l()));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <T extends Enum> void setEnumArray(String key, T[] array) {
        boolean nul = array == null;
        this.tag.func_74757_a(key + "_null", nul);
        if (nul) {
            return;
        }
        NBTTagList writtenObjects = new NBTTagList();
        for (T obj : array) {
            writtenObjects.func_74742_a((NBTBase)new NBTTagString(((Enum)obj).name()));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public <T extends NBT> void setArray(String key, T[] array) {
        boolean nul = array == null;
        this.tag.func_74757_a(key + "_null", nul);
        if (nul) {
            return;
        }
        NBTTagList writtenObjects = new NBTTagList();
        for (T obj : array) {
            writtenObjects.func_74742_a((NBTBase)NBTHelper.write(obj));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public String[] getStringSerializeArrayNames(String key) {
        if (this.tag.func_74767_n(key + "_null")) {
            return null;
        }
        NBTTagList nbtList = this.tag.func_150295_c(key, 8);
        String[] readObjects = new String[nbtList.func_74745_c()];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            readObjects[i] = nbtList.func_150307_f(i);
        }
        return readObjects;
    }

    public String[] getEnumArrayNames(String key) {
        if (this.tag.func_74767_n(key + "_null")) {
            return null;
        }
        NBTTagList nbtList = this.tag.func_150295_c(key, 8);
        String[] readObjects = new String[nbtList.func_74745_c()];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            readObjects[i] = nbtList.func_150307_f(i);
        }
        return readObjects;
    }

    public <T extends NBT> T[] getArray(String key, Class<? extends T> clazz) {
        if (this.tag.func_74767_n(key + "_null")) {
            return null;
        }
        NBTTagList nbtList = this.tag.func_150295_c(key, 10);
        NBT[] readObjects = (NBT[])Array.newInstance(clazz, nbtList.func_74745_c());
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            readObjects[i] = NBTHelper.read(nbtList.func_150305_b(i));
        }
        return readObjects;
    }

    public void setIntArray(String key, int[] array) {
        NBTTagList writtenObjects = new NBTTagList();
        for (int obj : array) {
            writtenObjects.func_74742_a((NBTBase)new NBTTagInt(obj));
        }
        this.tag.func_74782_a(key, (NBTBase)writtenObjects);
    }

    public int[] getIntArray(String key) {
        NBTTagList nbtList = this.tag.func_150295_c(key, 3);
        int[] readObjects = new int[nbtList.func_74745_c()];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            readObjects[i] = nbtList.func_186858_c(i);
        }
        return readObjects;
    }

    public void setBlockPos(String key, BlockPos pos) {
        NBTBase tag = NBTHelper.writeBlockPos(pos);
        this.tag.func_74782_a(key, tag);
    }

    public BlockPos getBlockPos(String key) {
        NBTTagCompound tag = this.tag.func_74775_l(key);
        return NBTHelper.readBlockPos(tag);
    }
}

