/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.io;

import com.gildedgames.orbis.lib.util.io.IClassSerializer;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.World;

public class SimpleSerializer
implements IClassSerializer {
    private final BiMap<Integer, Class> serialIDToClass = HashBiMap.create();
    private final Map<Class, Function<World, ?>> classToObjectCreation = Maps.newHashMap();
    private final String identifier;

    public SimpleSerializer(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public <T extends NBT> void register(int id, Class<T> clazz, Function<World, T> objectCreation) {
        this.serialIDToClass.put((Object)id, clazz);
        this.classToObjectCreation.put(clazz, objectCreation);
    }

    @Override
    public int serialize(Class<?> obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        int key = -1;
        try {
            key = (Integer)this.serialIDToClass.inverse().get(obj);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            System.out.println("Something went wrong! Looks like you haven't registered the object you're trying to serialize");
        }
        return key;
    }

    @Override
    public int serialize(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return this.serialize(obj.getClass());
    }

    @Override
    public <T extends NBT> T deserialize(World world, int id) {
        Class clazz = (Class)this.serialIDToClass.get((Object)id);
        NBT obj = (NBT)this.classToObjectCreation.get(clazz).apply(world);
        return (T)obj;
    }

    @Override
    public <T extends NBT> T deserialize(int id) {
        Class clazz = (Class)this.serialIDToClass.get((Object)id);
        NBT obj = (NBT)this.classToObjectCreation.get(clazz).apply(null);
        return (T)obj;
    }

    @Override
    public <T extends NBT> boolean isRegistered(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return this.classToObjectCreation.containsKey(clazz);
    }
}

