/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.mc;

import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BlockUtil {
    @Nullable
    public static TileEntity createTE(NBTTagCompound compound) {
        return TileEntity.func_190200_a(null, (NBTTagCompound)compound);
    }

    public static IBlockState getBlockState(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77952_i());
        }
        if (ItemMultiTexture.class.isAssignableFrom(stack.func_77973_b().getClass())) {
            return ((ItemMultiTexture)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77952_i());
        }
        return null;
    }

    @Deprecated
    public static boolean setTileEntityNBT(IBlockAccessExtended worldIn, BlockPos pos, ItemStack stack) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (minecraftserver == null) {
            return false;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("BlockEntityTag", 10) && (tileentity = worldIn.func_175625_s(pos)) != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74737_b();
            tileentity.func_189515_b(nbttagcompound);
            NBTTagCompound nbttagcompound2 = (NBTTagCompound)stack.func_77978_p().func_74781_a("BlockEntityTag");
            nbttagcompound.func_179237_a(nbttagcompound2);
            nbttagcompound.func_74768_a("x", pos.func_177958_n());
            nbttagcompound.func_74768_a("y", pos.func_177956_o());
            nbttagcompound.func_74768_a("z", pos.func_177952_p());
            if (!nbttagcompound.equals((Object)nbttagcompound1)) {
                tileentity.func_145839_a(nbttagcompound);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public static boolean isVoid(IBlockState state) {
        return state.func_177230_c() == Blocks.field_189881_dj;
    }

    public static boolean isSolid(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185904_a() != Material.field_151579_a && state.func_193401_d(world, pos, EnumFacing.DOWN) == BlockFaceShape.SOLID && state.func_185904_a().func_76218_k();
    }

    public static boolean isAir(IBlockState state) {
        return state.func_185904_a() == Material.field_151579_a;
    }

    public static boolean isSolid(IBlockState state) {
        Material material = state.func_185904_a();
        return material.func_76220_a() && state.func_185914_p();
    }

    public static int getTopBlockHeight(World world, int posX, int posZ) {
        Chunk chunk = world.func_72964_e(posX >> 4, posZ >> 4);
        int x = posX;
        int z = posZ;
        posX &= 0xF;
        posZ &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            IBlockState l = chunk.func_186032_a(posX, k, posZ);
            if (l == Blocks.field_150350_a.func_176223_P() || !l.func_185904_a().func_76230_c() || l.func_185904_a() == Material.field_151584_j || l.func_177230_c().isFoliage((IBlockAccess)world, new BlockPos(x, k, z))) continue;
            return k + 1;
        }
        return -1;
    }
}

