/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.mc;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.util.io.IClassSerializer;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class NBTHelper {
    public static NBTTagList getTagList(NBTTagCompound tag, String key) {
        return tag.func_150295_c(key, 10);
    }

    public static Iterable<NBTTagCompound> getIterator(NBTTagCompound tag, String tagListKey) {
        return NBTHelper.getIterator(NBTHelper.getTagList(tag, tagListKey));
    }

    public static Iterable<NBTTagCompound> getIterator(final NBTTagList tagList) {
        return new Iterable<NBTTagCompound>(){

            @Override
            public Iterator<NBTTagCompound> iterator() {
                return new AbstractIterator<NBTTagCompound>(){
                    private int i = 0;

                    protected NBTTagCompound computeNext() {
                        if (this.i >= tagList.func_74745_c()) {
                            return (NBTTagCompound)this.endOfData();
                        }
                        NBTTagCompound tag = tagList.func_150305_b(this.i);
                        ++this.i;
                        return tag;
                    }
                };
            }
        };
    }

    public static NBTTagCompound readNBTFromFile(String fileName) {
        return NBTHelper.readNBTFromFile(new File(DimensionManager.getCurrentSaveRootDirectory(), fileName));
    }

    public static NBTTagCompound readNBTFromFile(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            FileInputStream inputStream = new FileInputStream(file);
            return CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNBTToFile(NBTTagCompound tag, String fileName) {
        NBTHelper.writeNBTToFile(tag, new File(DimensionManager.getCurrentSaveRootDirectory(), fileName));
    }

    public static void writeNBTToFile(NBTTagCompound tag, File file) {
        file.mkdirs();
        File tmpFile = new File(file.getParentFile(), file.getName() + ".tmp");
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(tmpFile));
            if (file.exists()) {
                file.delete();
            }
            tmpFile.renameTo(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack readStack(NBTTagCompound tag) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = new ItemStack(OrbisLib.services().registrar().findItem(new ResourceLocation(tag.func_74779_i("id"))), (int)tag.func_74771_c("count"), (int)tag.func_74765_d("meta"));
        if (tag.func_74764_b("shareTag")) {
            itemstack.func_77982_d(tag.func_74775_l("shareTag"));
        }
        return itemstack;
    }

    public static NBTBase writeStack(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_190926_b()) {
            tag.func_74757_a("_null", true);
            return tag;
        }
        tag.func_74757_a("_null", false);
        tag.func_74778_a("id", OrbisLib.services().registrar().getIdentifierFor(stack.func_77973_b()).toString());
        tag.func_74774_a("count", (byte)stack.func_190916_E());
        tag.func_74777_a("meta", (short)stack.func_77960_j());
        NBTTagCompound nbttagcompound = null;
        if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
            nbttagcompound = stack.func_77973_b().getNBTShareTag(stack);
        }
        if (nbttagcompound != null) {
            tag.func_74782_a("shareTag", (NBTBase)nbttagcompound);
        }
        return tag;
    }

    public static BlockPos readBlockPos(NBTTagCompound tag) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return null;
        }
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public static NBTBase writeBlockPos(BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        if (pos == null) {
            tag.func_74757_a("_null", true);
            return tag;
        }
        tag.func_74757_a("_null", false);
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    public static ChunkPos readChunkPos(NBTTagCompound tag) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return null;
        }
        return new ChunkPos(tag.func_74762_e("x"), tag.func_74762_e("z"));
    }

    public static NBTBase writeChunkPos(ChunkPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        if (pos == null) {
            tag.func_74757_a("_null", true);
            return tag;
        }
        tag.func_74757_a("_null", false);
        tag.func_74768_a("x", pos.field_77276_a);
        tag.func_74768_a("z", pos.field_77275_b);
        return tag;
    }

    public static double[] readDoubleArray(NBTTagCompound tag) {
        if (tag == null || tag.func_74764_b("_null") && tag.func_74767_n("_null")) {
            return null;
        }
        double[] array = new double[tag.func_74762_e("length")];
        for (int i = 0; i < array.length; ++i) {
            array[i] = tag.func_74769_h(String.valueOf(i));
        }
        return array;
    }

    public static NBTBase writeDoubleArray(double[] array) {
        NBTTagCompound tag = new NBTTagCompound();
        if (array == null) {
            tag.func_74757_a("_null", true);
            return tag;
        }
        tag.func_74757_a("_null", false);
        tag.func_74768_a("length", array.length);
        int i = 0;
        for (double value : array) {
            tag.func_74780_a(String.valueOf(i), value);
            ++i;
        }
        return tag;
    }

    public static NBTTagCompound writeRaw(NBT nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        nbt.write(tag);
        return tag;
    }

    public static <T extends NBT> T clone(T nbt) {
        return NBTHelper.clone(null, nbt);
    }

    public static <T extends NBT> T clone(World world, T nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        nbt.write(tag);
        IClassSerializer serializer = OrbisLib.services().io().findSerializer(nbt);
        int id = serializer.serialize(nbt);
        Object obj = serializer.deserialize(world, id);
        obj.read(tag);
        return obj;
    }

    public static NBTTagCompound write(NBT nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        if (nbt == null) {
            tag.func_74757_a("_null", true);
            return tag;
        }
        IClassSerializer serializer = OrbisLib.services().io().findSerializer(nbt);
        tag.func_74757_a("_null", false);
        tag.func_74778_a("s_id", serializer.identifier());
        tag.func_74768_a("id", serializer.serialize(nbt));
        NBTTagCompound data = new NBTTagCompound();
        nbt.write(data);
        tag.func_74782_a("data", (NBTBase)data);
        return tag;
    }

    public static <T extends NBT> T readWithDefault(World world, NBTTagCompound tag, Supplier<T> def) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return (T)((NBT)def.get());
        }
        IClassSerializer serializer = OrbisLib.services().io().findSerializer(tag.func_74779_i("s_id"));
        int id = tag.func_74762_e("id");
        Object obj = serializer.deserialize(world, id);
        obj.read(tag.func_74775_l("data"));
        return obj;
    }

    public static <T extends NBT> T read(World world, NBTTagCompound tag) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return null;
        }
        IClassSerializer serializer = OrbisLib.services().io().findSerializer(tag.func_74779_i("s_id"));
        int id = tag.func_74762_e("id");
        Object obj = serializer.deserialize(world, id);
        obj.read(tag.func_74775_l("data"));
        return obj;
    }

    public static <T extends NBT> T readWithDefault(NBTTagCompound tag, Supplier<T> def) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return (T)((NBT)def.get());
        }
        IClassSerializer serializer = OrbisLib.services().io().findSerializer(tag.func_74779_i("s_id"));
        int id = tag.func_74762_e("id");
        Object obj = serializer.deserialize(id);
        obj.read(tag.func_74775_l("data"));
        return obj;
    }

    public static <T extends NBT> T read(NBTTagCompound tag) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return null;
        }
        IClassSerializer serializer = OrbisLib.services().io().findSerializer(tag.func_74779_i("s_id"));
        int id = tag.func_74762_e("id");
        Object obj = serializer.deserialize(id);
        obj.read(tag.func_74775_l("data"));
        return obj;
    }

    public static <T extends NBT> T loadWithoutReading(NBTTagCompound tag) {
        if (tag == null || tag.func_74767_n("_null") || !tag.func_74764_b("_null")) {
            return null;
        }
        IClassSerializer serializer = OrbisLib.services().io().findSerializer(tag.func_74779_i("s_id"));
        int id = tag.func_74762_e("id");
        return serializer.deserialize(id);
    }
}

