/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.mc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class StagedInventory<I extends IInventory> {
    private static final Map<String, Locator> registeredLocators = Maps.newHashMap();
    private I stagingInv;
    private I recordedInv;
    private Locator locator;
    private String locatorId;
    private EntityPlayer player;

    private StagedInventory() {
    }

    public StagedInventory(EntityPlayer player, Supplier<I> inventorySupplier, Locator locator, String locatorId) {
        this.player = player;
        this.stagingInv = (IInventory)inventorySupplier.get();
        this.recordedInv = (IInventory)inventorySupplier.get();
        this.locator = locator;
        this.locatorId = locatorId;
        registeredLocators.put(this.locatorId, this.locator);
    }

    public static boolean locatorExists(String locatorId) {
        return registeredLocators.containsKey(locatorId);
    }

    public static Locator getLocator(String locatorId) {
        return registeredLocators.get(locatorId);
    }

    public String getLocatorId() {
        return this.locatorId;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void update() {
        World world = this.player.func_130014_f_();
        ArrayList updates = world.field_72995_K ? Collections.emptyList() : Lists.newArrayList();
        for (int i = 0; i < this.stagingInv.func_70302_i_(); ++i) {
            ItemStack newStack;
            ItemStack oldStack = this.recordedInv.func_70301_a(i);
            if (ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)(newStack = this.stagingInv.func_70301_a(i)))) continue;
            if (!world.field_72995_K) {
                updates.add(Pair.of((Object)i, (Object)newStack));
            }
            this.recordedInv.func_70299_a(i, newStack.func_190926_b() ? ItemStack.field_190927_a : newStack.func_77946_l());
        }
        if (!world.field_72995_K) {
            // empty if block
        }
    }

    public I get() {
        return this.stagingInv;
    }

    public static interface Locator {
        public StagedInventory locate(EntityPlayer var1);
    }
}

