/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.random;

import com.gildedgames.orbis.lib.util.random.SplitMixRandom;
import java.util.Random;

public class XoRoShiRoRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long s0;
    private long s1;
    private static final SplitMixRandom seedUniquifier = new SplitMixRandom(System.nanoTime());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long randomSeed() {
        long x;
        SplitMixRandom splitMixRandom = seedUniquifier;
        synchronized (splitMixRandom) {
            x = seedUniquifier.nextLong();
        }
        return x ^ System.nanoTime();
    }

    public XoRoShiRoRandom() {
        this(XoRoShiRoRandom.randomSeed());
    }

    public XoRoShiRoRandom(long seed) {
        this.setSeed(seed);
    }

    @Override
    public long nextLong() {
        long s0 = this.s0;
        long s1 = this.s1;
        long result = s0 + s1;
        this.s0 = Long.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.s1 = Long.rotateLeft(s1, 37);
        return result;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    private long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t >>> Long.numberOfLeadingZeros(nMinus1) & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    @Override
    public double nextDouble() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        while (i != 0) {
            int n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
        SplitMixRandom r = new SplitMixRandom(seed);
        this.s0 = r.nextLong();
        this.s1 = r.nextLong();
    }

    public void setState(long[] state) {
        if (state.length != 2) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of 2");
        }
        this.s0 = state[0];
        this.s1 = state[1];
    }
}

