/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.util.random;

import com.gildedgames.orbis.lib.util.random.SplitMixRandom;

public class XorshiftGenerator {
    private long state;
    private static final SplitMixRandom seedUniquifier = new SplitMixRandom(System.nanoTime());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long randomSeed() {
        long x;
        SplitMixRandom splitMixRandom = seedUniquifier;
        synchronized (splitMixRandom) {
            x = seedUniquifier.nextLong();
        }
        return x ^ System.nanoTime();
    }

    public XorshiftGenerator() {
        this(XorshiftGenerator.randomSeed());
    }

    public XorshiftGenerator(long seed) {
        this.setSeed(seed);
    }

    public long nextLong() {
        long x = this.state;
        x ^= x << 13;
        x ^= x >> 17;
        x ^= x << 5;
        this.state = x;
        return x;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    private long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t >>> Long.numberOfLeadingZeros(nMinus1) & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    public double nextDouble() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    public void setSeed(long seed) {
        this.state = seed == 0L ? 195948557L : seed;
    }
}

