/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world;

import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.world.IWorldObject;
import com.gildedgames.orbis.lib.world.IWorldObjectManagerObserver;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class WorldObjectManager
extends WorldSavedData {
    private static final String DATA_NAME = "Orbis_WorldObjectManager";
    private final List<IWorldObjectManagerObserver> observers = Lists.newArrayList();
    private int dimension;
    private World world;
    private BiMap<Integer, IWorldObject> idToObject = HashBiMap.create();
    private int nextId;

    public WorldObjectManager() {
        super(DATA_NAME);
    }

    public WorldObjectManager(String s) {
        super(s);
    }

    public WorldObjectManager(World world) {
        super(DATA_NAME);
        this.world = world;
    }

    public static WorldObjectManager get(World world) {
        MapStorage storage;
        WorldObjectManager instance;
        World using;
        if (world.field_72995_K) {
            if (Minecraft.func_71410_x().func_71387_A()) {
                using = DimensionManager.getWorld((int)world.field_73011_w.getDimension());
                if (using == null) {
                    using = world;
                }
            } else {
                using = world;
            }
        } else {
            using = world.func_73046_m().func_71218_a(world.field_73011_w.getDimension());
        }
        if ((instance = (WorldObjectManager)(storage = using.getPerWorldStorage()).func_75742_a(WorldObjectManager.class, DATA_NAME)) == null) {
            instance = new WorldObjectManager(world);
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    private void refreshObserver(IWorldObjectManagerObserver observer) {
        observer.onReloaded(this);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void updateObjects() {
        for (IWorldObject obj : this.idToObject.values()) {
            obj.onUpdate();
        }
    }

    public void checkForDirtyObjects() {
        for (IWorldObject obj : this.idToObject.values()) {
            if (!obj.isDirty()) continue;
            this.func_76185_a();
            break;
        }
        if (this.func_76188_b()) {
            for (IWorldObject obj : this.idToObject.values()) {
                if (!obj.isDirty()) continue;
                obj.markClean();
            }
        }
    }

    public <T extends IWorldObject> boolean hasObject(T object) {
        return this.idToObject.inverse().containsKey(object);
    }

    public int getID(IWorldObject object) {
        if (object == null) {
            throw new NullPointerException();
        }
        BiMap inverse = this.idToObject.inverse();
        return (Integer)inverse.getOrDefault((Object)object, (Object)-1);
    }

    public <T extends IWorldObject> T getObject(int id) {
        return (T)((IWorldObject)this.idToObject.get((Object)id));
    }

    public <T extends IWorldObject> void setObject(int id, T object) {
        this.idToObject.put((Object)id, object);
        for (IWorldObjectManagerObserver observer : this.observers) {
            observer.onObjectAdded(this, object);
        }
        this.func_76185_a();
    }

    public <T extends IWorldObject> int addObject(T object) {
        int id = this.fetchNextId();
        this.setObject(id, object);
        return id;
    }

    public int fetchNextId() {
        return this.nextId++;
    }

    public <T extends IWorldObject> boolean removeObject(T object) {
        return this.removeObject(this.getID(object));
    }

    public boolean removeObject(int id) {
        IWorldObject object = (IWorldObject)this.idToObject.get((Object)id);
        if (this.idToObject.containsKey((Object)id)) {
            this.idToObject.remove((Object)id);
            for (IWorldObjectManagerObserver observer : this.observers) {
                observer.onObjectRemoved(this, object);
            }
            this.func_76185_a();
        }
        return object != null;
    }

    public Collection<IWorldObject> getObjects() {
        return this.idToObject.values();
    }

    public void addObserver(IWorldObjectManagerObserver observer) {
        this.observers.add(observer);
        this.refreshObserver(observer);
    }

    public boolean removeObserver(IWorldObjectManagerObserver observer) {
        return this.observers.remove(observer);
    }

    public boolean containsObserver(IWorldObjectManagerObserver observer) {
        return this.observers.contains(observer);
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        this.nextId = tag.func_74762_e("nextId");
        this.dimension = tag.func_74762_e("dimension");
        if (this.world == null) {
            this.world = DimensionManager.getWorld((int)this.dimension);
        }
        this.idToObject = HashBiMap.create(funnel.getIntMap(this.world, "objects"));
        for (IWorldObjectManagerObserver observer : this.observers) {
            observer.onReloaded(this);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTFunnel funnel = new NBTFunnel(tag);
        tag.func_74768_a("nextId", this.nextId);
        tag.func_74768_a("dimension", this.dimension);
        funnel.setIntMap("objects", (Map<Integer, ? extends NBT>)this.idToObject);
        return tag;
    }
}

