/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world;

import com.gildedgames.orbis.lib.data.region.IShape;
import com.gildedgames.orbis.lib.util.RegionHelp;
import com.gildedgames.orbis.lib.world.IWorldObject;
import com.gildedgames.orbis.lib.world.WorldObjectManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldObjectUtils {
    public static <T extends IShape> Optional<T> getIntersectingShape(World world, BlockPos pos, Class<T> tClass) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!tClass.isInstance(obj) || !(area = (IShape)tClass.cast(obj)).contains(pos)) continue;
            return Optional.of(area);
        }
        return Optional.empty();
    }

    public static Optional<IShape> getIntersectingShape(World world, BlockPos pos) {
        return WorldObjectUtils.getIntersectingShape(world, pos, IShape.class);
    }

    public static <T extends IShape> T getIntersectingShape(World world, Class<T> shapeType, BlockPos pos) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!(obj instanceof IShape) || !(area = (IShape)((Object)obj)).contains(pos) || area.getClass() != shapeType) continue;
            return (T)((IShape)shapeType.cast(area));
        }
        return null;
    }

    public static IShape getIntersectingShape(World world, IShape shape) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!(obj instanceof IShape) || !RegionHelp.intersects2D(area = (IShape)((Object)obj), shape)) continue;
            return area;
        }
        return null;
    }

    public static <T extends IShape> T getIntersectingShape(World world, Class<T> shapeType, IShape shape) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!(obj instanceof IShape) || !RegionHelp.intersects2D(area = (IShape)((Object)obj), shape) || area.getClass() != shapeType) continue;
            return (T)((IShape)shapeType.cast(area));
        }
        return null;
    }

    public static <T extends IShape> List<T> getIntersectingShapes(World world, Class<T> shapeType, IShape shape) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        ArrayList intersecting = Lists.newArrayList();
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!(obj instanceof IShape) || !RegionHelp.intersects2D(area = (IShape)((Object)obj), shape) || area.getClass() != shapeType) continue;
            intersecting.add(shapeType.cast(area));
        }
        return intersecting;
    }

    public static IShape getContainedShape(World world, IShape shape) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!(obj instanceof IShape) || !RegionHelp.contains(area = (IShape)((Object)obj), shape)) continue;
            return area;
        }
        return null;
    }

    public static <T extends IShape> T getContainedShape(World world, Class<T> shapeType, IShape shape) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!(obj instanceof IShape) || !RegionHelp.contains(area = (IShape)((Object)obj), shape) || area.getClass() != shapeType) continue;
            return (T)((IShape)shapeType.cast(area));
        }
        return null;
    }

    public static <T extends IShape> List<T> getContainedShapes(World world, Class<T> shapeType, IShape shape) {
        WorldObjectManager manager = WorldObjectManager.get(world);
        ArrayList contained = Lists.newArrayList();
        for (IWorldObject obj : manager.getObjects()) {
            IShape area;
            if (!(obj instanceof IShape) || !RegionHelp.contains(shape, area = (IShape)((Object)obj)) || area.getClass() != shapeType) continue;
            contained.add(shapeType.cast(area));
        }
        return contained;
    }

    public static boolean isIntersectingShapes(World world, IShape shape) {
        return WorldObjectUtils.getIntersectingShape(world, shape) != null;
    }

    public static boolean isContainedInShape(World world, IShape shape) {
        return WorldObjectUtils.getContainedShape(world, shape) != null;
    }
}

