/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class WorldSlice {
    private final World world;
    private final Chunk[] chunks;
    private final ExtendedBlockStorage[] sections;
    private final int offsetX;
    private final int offsetZ;
    private final IBlockState defaultBlockState = Blocks.field_150350_a.func_176223_P();

    public WorldSlice(World world, ChunkPos pos) {
        this.world = world;
        this.chunks = new Chunk[9];
        this.sections = new ExtendedBlockStorage[this.chunks.length * 16];
        this.offsetX = pos.field_77276_a * 16 - 16;
        this.offsetZ = pos.field_77275_b * 16 - 16;
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                int chunkX = pos.field_77276_a + x - 1;
                int chunkZ = pos.field_77275_b + z - 1;
                Chunk chunk = world.func_72863_F().func_186026_b(chunkX, chunkZ);
                if (chunk == null) continue;
                this.chunks[x * 3 + z] = chunk;
                for (int y = 0; y < 16; ++y) {
                    this.sections[z + y * 3 + x * 16 * 3] = chunk.func_76587_i()[y];
                }
            }
        }
    }

    public IBlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IBlockState getBlockState(int x, int y, int z) {
        int chunkX;
        int chunkZ;
        ExtendedBlockStorage section;
        if (y >= 0 && y < 256 && (section = this.sections[(chunkZ = z - this.offsetZ >> 4) + (y >> 4) * 3 + (chunkX = x - this.offsetX >> 4) * 16 * 3]) != null) {
            return section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
        }
        return this.defaultBlockState;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.isAirBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean setBlockState(BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            int chunkZ;
            int chunkX = pos.func_177958_n() - this.offsetX >> 4;
            Chunk chunk = this.chunks[chunkX * 3 + (chunkZ = pos.func_177952_p() - this.offsetZ >> 4)];
            if (chunk == null) {
                return false;
            }
            IBlockState prev = chunk.func_177436_a(pos, state);
            if (prev != null && prev != state) {
                this.world.func_184138_a(pos, prev, state, 19);
            }
            return true;
        }
        return false;
    }

    public boolean isAreaWithin(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (minY < 0 || minY > 255) {
            return false;
        }
        if (maxY < 0 || maxY > 255) {
            return false;
        }
        int minChunkX = minX - this.offsetX >> 4;
        int minChunkZ = minZ - this.offsetZ >> 4;
        int maxChunkX = maxX - this.offsetX >> 4;
        int maxChunkZ = maxZ - this.offsetZ >> 4;
        if (minChunkX < 0 || minChunkX > 2 || minChunkZ < 0 || minChunkZ > 2) {
            return false;
        }
        return maxChunkX >= 0 && maxChunkX <= 2 && maxChunkZ >= 0 && maxChunkZ <= 2;
    }

    public boolean isAreaWithin(BlockPos pos, int radius) {
        return this.isAreaWithin(pos.func_177958_n() - radius, pos.func_177956_o() - radius, pos.func_177952_p() - radius, pos.func_177958_n() + radius, pos.func_177956_o() + radius, pos.func_177952_p() + radius);
    }

    public boolean isBlockWithin(BlockPos pos) {
        return this.isBlockWithin(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean isBlockWithin(int x, int y, int z) {
        if (y < 0 || y > 255) {
            return false;
        }
        int chunkX = x - this.offsetX >> 4;
        int chunkZ = z - this.offsetZ >> 4;
        return chunkX >= 0 && chunkX <= 2 && chunkZ >= 0 && chunkZ <= 2;
    }

    public BlockPos getHighestBlockPos(int x, int z) {
        return new BlockPos(x, this.getHeighestBlockValue(x, z), z);
    }

    public int getHeighestBlockValue(int x, int z) {
        return this.world.func_72964_e(x >> 4, z >> 4).func_76611_b(x & 0xF, z & 0xF);
    }

    public boolean isAirBlock(int x, int y, int z) {
        return this.getBlockState(x, y, z).func_185904_a() == Material.field_151579_a;
    }
}

