/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world.data;

import com.gildedgames.orbis.lib.world.data.IWorldDataManager;
import com.gildedgames.orbis.lib.world.data.IWorldDataManagerContainer;
import com.gildedgames.orbis.lib.world.data.WorldDataManagerFlat;
import com.gildedgames.orbis.lib.world.data.WorldDataStorageMethod;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class WorldDataManagerContainer
implements IWorldDataManagerContainer {
    private final World world;
    private IWorldDataManager manager;
    private WorldDataStorageMethod lastStorageMethod;

    public WorldDataManagerContainer() {
        this.world = null;
    }

    public WorldDataManagerContainer(World world) {
        this.world = world;
    }

    @Override
    public IWorldDataManager get() {
        if (this.manager == null && this.world != null) {
            this.manager = this.createDataManager(this.world);
        }
        return this.manager;
    }

    @Override
    public WorldDataStorageMethod getLastStorageMethod() {
        return this.lastStorageMethod;
    }

    @Override
    public void setLastStorageMethod(WorldDataStorageMethod method) {
        this.lastStorageMethod = method;
    }

    private IWorldDataManager createDataManager(World world) {
        if (this.lastStorageMethod == null) {
            this.lastStorageMethod = WorldDataStorageMethod.FLAT;
        }
        File dir = new File(world.func_72860_G().func_75765_b(), (world.field_73011_w.getSaveFolder() == null ? "" : world.field_73011_w.getSaveFolder()) + "/data/orbis/");
        if (this.lastStorageMethod == WorldDataStorageMethod.FLAT) {
            return new WorldDataManagerFlat(dir);
        }
        throw new IllegalStateException("Don't know how to initialize '" + this.lastStorageMethod.serializedName + "' storage");
    }

    public static class Storage
    implements Capability.IStorage<IWorldDataManagerContainer> {
        @Nullable
        public NBTBase writeNBT(Capability<IWorldDataManagerContainer> capability, IWorldDataManagerContainer instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            if (instance.getLastStorageMethod() != null) {
                tag.func_74778_a("LastStorageMethod", instance.getLastStorageMethod().serializedName);
            }
            return tag;
        }

        public void readNBT(Capability<IWorldDataManagerContainer> capability, IWorldDataManagerContainer instance, EnumFacing side, NBTBase nbt) {
            String name = ((NBTTagCompound)nbt).func_74779_i("LastStorageMethod");
            for (WorldDataStorageMethod method : WorldDataStorageMethod.values()) {
                if (!method.serializedName.equals(name)) continue;
                instance.setLastStorageMethod(method);
                break;
            }
        }
    }
}

