/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world.data;

import com.gildedgames.orbis.lib.OrbisLibCapabilities;
import com.gildedgames.orbis.lib.world.data.IWorldDataManagerContainer;
import com.gildedgames.orbis.lib.world.data.WorldDataManagerContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class WorldDataManagerContainerProvider
implements ICapabilitySerializable<NBTBase> {
    private final IWorldDataManagerContainer container;
    private final WorldDataManagerContainer.Storage storage = new WorldDataManagerContainer.Storage();

    public WorldDataManagerContainerProvider(World world) {
        this.container = new WorldDataManagerContainer(world);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == OrbisLibCapabilities.WORLD_DATA;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this.container;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return this.storage.writeNBT(OrbisLibCapabilities.WORLD_DATA, this.container, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        this.storage.readNBT(OrbisLibCapabilities.WORLD_DATA, this.container, null, nbt);
    }
}

