/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world.data;

import com.gildedgames.orbis.lib.world.data.IWorldData;
import com.gildedgames.orbis.lib.world.data.IWorldDataManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class WorldDataManagerFlat
implements IWorldDataManager {
    private final File file;
    private final List<IWorldData> registered = new ArrayList<IWorldData>();
    private boolean closed;

    public WorldDataManagerFlat(File file) {
        this.file = new File(file, "flat");
    }

    @Override
    public void register(IWorldData data) {
        this.checkClosed();
        if (data.getName() == null) {
            throw new IllegalArgumentException("Data name can not be null");
        }
        File dirs = new File(this.file, data.getName().func_110624_b() + "/" + data.getName().func_110623_a());
        if (!dirs.isDirectory() && !dirs.mkdirs()) {
            throw new RuntimeException("Failed to create data directory at " + dirs.getAbsolutePath());
        }
        this.registered.add(data);
    }

    @Override
    public byte[] readBytes(IWorldData data, String path) throws IOException {
        this.checkClosed();
        File file = this.getFile(data, path);
        if (!file.exists()) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    public void writeBytes(IWorldData data, String path, byte[] bytes) throws IOException {
        this.checkClosed();
        File file = this.getFile(data, path);
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new RuntimeException("Failed to create parent directory for " + file.getAbsolutePath());
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            IOUtils.write((byte[])bytes, (OutputStream)out);
        }
    }

    private File getFile(IWorldData data, String path) {
        return new File(this.file, data.getName().func_110624_b() + "/" + data.getName().func_110623_a() + "/" + path);
    }

    @Override
    public void flush() {
        this.registered.forEach(IWorldData::flush);
    }

    @Override
    public void close() {
        this.flush();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("World storage has been closed!");
        }
    }
}

