/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world.instances;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.util.TeleporterGeneric;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import com.gildedgames.orbis.lib.world.instances.IInstance;
import com.gildedgames.orbis.lib.world.instances.IInstanceFactory;
import com.gildedgames.orbis.lib.world.instances.IInstanceHandler;
import com.gildedgames.orbis.lib.world.instances.IPlayerInstances;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class InstanceHandler<T extends IInstance>
implements IInstanceHandler<T> {
    private final BiMap<Integer, T> instances = HashBiMap.create();
    private final IInstanceFactory<T> factory;

    public InstanceHandler(IInstanceFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public T createNew() {
        T instance = this.factory.createInstance(DimensionManager.getNextFreeDimId(), this);
        this.registerInstance(instance);
        return instance;
    }

    @Override
    public void unloadAllInstances() {
        for (IInstance instance : this.instances.values()) {
            OrbisLib.instances().unloadInstance(instance);
        }
        this.instances.clear();
    }

    @Override
    public void registerInstance(T instance) {
        OrbisLib.instances().loadInstance((IInstance)instance);
        this.instances.put((Object)instance.getDimensionId(), instance);
    }

    @Override
    public void unregisterInstance(T instance) {
        if (instance.isTemporary() && instance.getPlayers().isEmpty()) {
            OrbisLib.instances().unloadInstance((IInstance)instance);
            this.instances.remove((Object)instance.getDimensionId());
        }
    }

    @Override
    public void write(NBTTagCompound output) {
        output.func_74757_a("hasWrittenInstances", this.instances.size() > 0);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry entry : this.instances.entrySet()) {
            IInstance instance = (IInstance)entry.getValue();
            NBTTagCompound newTag = new NBTTagCompound();
            newTag.func_74768_a("dimension", ((Integer)entry.getKey()).intValue());
            instance.write(newTag);
            tagList.func_74742_a((NBTBase)newTag);
        }
        output.func_74782_a("instances", (NBTBase)tagList);
    }

    @Override
    public void read(NBTTagCompound input) {
        boolean hasWrittenInstances = input.func_74767_n("hasWrittenInstances");
        if (!hasWrittenInstances) {
            return;
        }
        for (NBTTagCompound tag : NBTHelper.getIterator(input, "instances")) {
            int id = tag.func_74762_e("dimension");
            T instance = this.factory.createInstance(id, this);
            instance.read(tag);
            this.registerInstance(instance);
        }
    }

    @Override
    public T getInstanceForDimension(int dimensionId) {
        return (T)((IInstance)this.instances.get((Object)dimensionId));
    }

    @Override
    public Collection<T> getLoadedInstances() {
        return Collections.unmodifiableCollection(this.instances.values());
    }

    @Override
    public World teleportPlayerToInstance(T instance, EntityPlayerMP player) {
        if (this.instances.containsValue(instance)) {
            IPlayerInstances hook = OrbisLib.instances().getPlayer((EntityPlayer)player);
            if (hook.getInstance() != null) {
                hook.getInstance().onLeave((EntityPlayer)player);
                hook.setInstance(null);
            }
            hook.setReturnPosition(new BlockPosDimension((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player.field_71093_bK));
            int dimId = instance.getDimensionId();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer world = server.func_71218_a(dimId);
            Teleporter teleporter = this.factory.getTeleporter(world);
            PlayerList playerList = server.func_184103_al();
            playerList.transferPlayerToDimension(player, dimId, teleporter);
            player.field_71088_bW = player.func_82147_ab();
            hook.setInstance((IInstance)instance);
            instance.onJoin((EntityPlayer)player);
            return world;
        }
        return player.field_70170_p;
    }

    @Override
    public void returnPlayerFromInstance(EntityPlayerMP player) {
        IPlayerInstances hook = OrbisLib.instances().getPlayer((EntityPlayer)player);
        if (hook.getInstance() != null && hook.getOutside() != null) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            BlockPosDimension pos = hook.getOutside();
            TeleporterGeneric teleporter = new TeleporterGeneric(server.func_71218_a(player.field_71093_bK));
            PlayerList playerList = server.func_184103_al();
            playerList.transferPlayerToDimension(player, pos.getDim(), (Teleporter)teleporter);
            player.field_71088_bW = player.func_82147_ab();
            hook.setReturnPosition(null);
            hook.setInstance(null);
            player.field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
        }
    }
}

