/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world.instances;

import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.OrbisLibCapabilities;
import com.gildedgames.orbis.lib.network.instances.PacketRegisterDimension;
import com.gildedgames.orbis.lib.network.instances.PacketUnregisterDimension;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import com.gildedgames.orbis.lib.world.instances.IInstance;
import com.gildedgames.orbis.lib.world.instances.IInstanceFactory;
import com.gildedgames.orbis.lib.world.instances.IInstanceHandler;
import com.gildedgames.orbis.lib.world.instances.IInstanceRegistry;
import com.gildedgames.orbis.lib.world.instances.IPlayerInstances;
import com.gildedgames.orbis.lib.world.instances.InstanceHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.commons.io.FileUtils;

public class InstanceRegistryImpl
implements IInstanceRegistry {
    private static final String FILE_PATH = "//data//instances.dat";
    private List<IInstanceHandler> registeredHandlers = new ArrayList<IInstanceHandler>();
    private HashSet<IInstance> instances = new HashSet();
    private HashSet<IInstance> deleteQueue = new HashSet();

    @Override
    public List<IInstanceHandler> getInstanceHandlers() {
        return Collections.unmodifiableList(this.registeredHandlers);
    }

    @Override
    public Collection<IInstance> getInstances() {
        return Collections.unmodifiableCollection(this.instances);
    }

    public <T extends IInstance> InstanceHandler<T> createInstanceHandler(IInstanceFactory<T> factory) {
        InstanceHandler<T> handler = new InstanceHandler<T>(factory);
        this.registeredHandlers.add(handler);
        return handler;
    }

    @Override
    public IPlayerInstances getPlayer(EntityPlayer player) {
        return (IPlayerInstances)player.getCapability(OrbisLibCapabilities.PLAYER_INSTANCES, null);
    }

    @Override
    public IPlayerInstances getPlayer(UUID uuid) {
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
        if (player == null) {
            return null;
        }
        return this.getPlayer((EntityPlayer)player);
    }

    @Override
    public void loadInstance(IInstance instance) {
        int id = instance.getDimensionId();
        DimensionType type = instance.getDimensionType();
        if (DimensionManager.isDimensionRegistered((int)id)) {
            throw new IllegalStateException("Tried to register DIM" + id + ", but it's already registered");
        }
        DimensionManager.registerDimension((int)id, (DimensionType)type);
        OrbisLib.LOGGER.info("DimensionType " + type.func_186065_b() + " registered (ID: " + id + ") to instance registry");
        if (OrbisLib.isServer()) {
            OrbisLib.network().sendPacketToAllPlayers(new PacketRegisterDimension(instance.getDimensionType(), instance.getDimensionId()));
        }
        this.instances.add(instance);
    }

    @Override
    public void unloadInstance(IInstance instance) {
        int id = instance.getDimensionId();
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            throw new IllegalStateException("Tried to unload DIM" + id + ", but it isn't registered");
        }
        DimensionManager.unloadWorld((int)id);
        if (instance.isTemporary()) {
            this.deleteQueue.add(instance);
            OrbisLib.LOGGER.info("Dimension ID " + id + " queued to unload");
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Collection unloaded = this.deleteQueue.stream().filter(instance -> DimensionManager.getWorld((int)instance.getDimensionId()) == null).collect(Collectors.toList());
        for (IInstance instance2 : unloaded) {
            if (instance2.getPlayers().isEmpty()) {
                this.deleteDimension(instance2);
            }
            this.deleteQueue.remove(instance2);
        }
    }

    private void deleteDimension(IInstance instance) {
        int id = instance.getDimensionId();
        OrbisLib.LOGGER.info("Dimension with ID " + id + " queued for deletion");
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        server.func_152344_a(() -> {
            File file = new File(server.func_130014_f_().func_72860_G().func_75765_b(), "DIM" + id);
            if (!file.isDirectory()) {
                OrbisLib.LOGGER.warn("World save directory '" + file.getAbsolutePath() + "' doesn't exist, cannot delete (this is likely a severe bug)");
                return;
            }
            OrbisLib.LOGGER.info("Dimension with ID " + id + " is being deleted");
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                OrbisLib.LOGGER.warn("Failed to cleanup dimension ID " + id);
                return;
            }
            OrbisLib.LOGGER.info("Deleted dimension with ID " + id + ", unregistering...");
            this.unregisterInstance(instance);
        });
    }

    private void unregisterInstance(IInstance instance) {
        int id = instance.getDimensionId();
        DimensionManager.unregisterDimension((int)id);
        if (OrbisLib.isServer()) {
            OrbisLib.network().sendPacketToAllPlayers(new PacketUnregisterDimension(instance.getDimensionId()));
        }
        this.instances.remove(instance);
        this.deleteQueue.remove(instance);
    }

    @Override
    public void loadAllInstancesFromDisk() {
        NBTTagCompound tag = NBTHelper.readNBTFromFile(FILE_PATH);
        if (tag == null) {
            return;
        }
        int i = 0;
        for (IInstanceHandler handler : this.getInstanceHandlers()) {
            NBTTagCompound subTag = tag.func_74775_l(String.valueOf(i++));
            handler.read(subTag);
        }
    }

    @Override
    public void cleanup() {
        this.registeredHandlers.forEach(IInstanceHandler::unloadAllInstances);
        for (IInstance instance : this.instances) {
            DimensionManager.unregisterDimension((int)instance.getDimensionId());
            if (!OrbisLib.isServer()) continue;
            OrbisLib.network().sendPacketToAllPlayers(new PacketUnregisterDimension(instance.getDimensionId()));
        }
        this.instances.clear();
        this.deleteQueue.clear();
    }

    @Override
    public void saveAllInstancesToDisk() {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        tag.func_74768_a("size", OrbisLib.instances().getInstanceHandlers().size());
        for (IInstanceHandler handler : this.getInstanceHandlers()) {
            NBTTagCompound subTag = new NBTTagCompound();
            handler.write(subTag);
            tag.func_74782_a(String.valueOf(i++), (NBTBase)subTag);
        }
        NBTHelper.writeNBTToFile(tag, FILE_PATH);
    }

    @SubscribeEvent
    public void onWorldSaved(WorldEvent.Save event) {
        this.saveAllInstancesToDisk();
    }

    @SubscribeEvent
    public void onClientJoinedServer(PlayerEvent.PlayerLoggedInEvent event) {
        for (IInstance instance : this.instances) {
            OrbisLib.network().sendPacketToPlayer(new PacketRegisterDimension(instance.getDimensionType(), instance.getDimensionId()), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            this.cleanup();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerTravel(PlayerEvent.PlayerChangedDimensionEvent event) {
        IPlayerInstances hook = this.getPlayer(event.player);
        if (hook.getInstance() != null) {
            hook.getInstance().onLeave(event.player);
            hook.setInstance(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player.field_70170_p.field_72995_K || !event.player.field_70170_p.field_73011_w.func_76567_e()) {
            return;
        }
        IPlayerInstances hook = this.getPlayer(event.player);
        if (hook.getInstance() == null) {
            return;
        }
        hook.getInstance().onRespawn(event.player);
    }
}

