/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.orbis.lib.world.instances;

import com.gildedgames.orbis.lib.OrbisLibCapabilities;
import com.gildedgames.orbis.lib.world.instances.PlayerInstances;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class PlayerInstancesProvider
implements ICapabilitySerializable<NBTBase> {
    private final PlayerInstances.Storage storage = new PlayerInstances.Storage();
    private final EntityPlayer player;
    private PlayerInstances capability;

    public PlayerInstancesProvider(EntityPlayer player) {
        this.player = player;
    }

    private PlayerInstances fetchCapability() {
        if (this.capability == null) {
            this.capability = new PlayerInstances();
        }
        return this.capability;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == OrbisLibCapabilities.PLAYER_INSTANCES;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this.fetchCapability();
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return this.storage.writeNBT(OrbisLibCapabilities.PLAYER_INSTANCES, this.fetchCapability(), null);
    }

    public void deserializeNBT(NBTBase nbt) {
        this.storage.readNBT(OrbisLibCapabilities.PLAYER_INSTANCES, this.fetchCapability(), null, nbt);
    }
}

