/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.explosives;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.capability.projectile.TinkerProjectileHandler;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.ILauncher;
import slimeknights.tconstruct.library.tools.ranged.IProjectile;
import slimeknights.tconstruct.library.utils.AmmoHelper;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ExplosionTinkersBase {
    protected static final UUID PROJECTILE_POWER_MODIFIER = UUID.fromString("c6aefc21-081a-4c4a-b076-8f9d6cef9122");
    private final Random random = new Random();
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private TinkerProjectileHandler tinkerProjectile;
    private EntityLivingBase attacker;
    private final Entity explosionSource;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Vec3d position;

    @SideOnly(value=Side.CLIENT)
    public ExplosionTinkersBase(World worldIn, Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, new TinkerProjectileHandler(), null);
        this.affectedBlockPositions.addAll(affectedPositions);
    }

    public ExplosionTinkersBase(World worldIn, Entity entityIn, double x, double y, double z, float size, TinkerProjectileHandler tinkerProjectile, EntityLivingBase attacker) {
        this.world = worldIn;
        this.explosionSource = entityIn;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.tinkerProjectile = tinkerProjectile;
        this.position = new Vec3d(this.x, this.y, this.z);
        this.attacker = attacker;
    }

    public void doExplosionA() {
        float f3 = this.size;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f3 - 2.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f3 + 2.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f3 - 2.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f3 + 2.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f3 - 2.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f3 + 2.0));
        f3 *= 2.0f;
        List list = this.world.func_72839_b(this.explosionSource, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        Vec3d vec3d = new Vec3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            EntityPlayer entityplayer;
            double d10;
            double d9;
            double d7;
            double d5;
            double d13;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV()) continue;
            this.attackEntity(entity);
            double d12 = entity.func_70011_f(this.x, this.y, this.z);
            if (!(d12 <= (double)f3 * 1.5) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.x) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * d7 + (d9 = entity.field_70161_v - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.world.func_72842_a(vec3d, entity.func_174813_aQ());
            double d11 = d10 = (1.0 - d12 / (double)f3) * d14;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.playerKnockbackMap.put(entityplayer, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void doExplosionB(boolean spawnParticles) {
        this.world.func_184148_a((EntityPlayer)null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.world instanceof WorldServer) {
            if (this.size >= 2.0f) {
                ((WorldServer)this.world).func_180505_a(EnumParticleTypes.EXPLOSION_HUGE, true, this.x, this.y, this.z, 2, 0.0, 0.0, 0.0, 0.0, new int[0]);
            } else {
                ((WorldServer)this.world).func_180505_a(EnumParticleTypes.EXPLOSION_LARGE, true, this.x, this.y, this.z, 2, 0.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void clearAffectedBlockPositions() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> getAffectedBlockPositions() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public void attackEntity(Entity entityToHit) {
        ItemStack item = this.tinkerProjectile.getItemStack();
        ItemStack launcher = this.tinkerProjectile.getLaunchingStack();
        if (item.func_77973_b() instanceof ToolCore && this.attacker != null) {
            boolean brokenStateDiffers;
            EntityLivingBase attacker = this.attacker;
            ItemStack inventoryItem = AmmoHelper.getMatchingItemstackFromInventory((ItemStack)this.tinkerProjectile.getItemStack(), (Entity)attacker, (boolean)false);
            if (inventoryItem.func_190926_b() || inventoryItem.func_77973_b() != item.func_77973_b()) {
                inventoryItem = item;
            }
            boolean bl = brokenStateDiffers = ToolHelper.isBroken((ItemStack)inventoryItem) != ToolHelper.isBroken((ItemStack)item);
            if (brokenStateDiffers) {
                this.toggleBroken(inventoryItem);
            }
            Multimap projectileAttributes = null;
            if (!this.world.field_72995_K) {
                this.unequip(attacker, EntityEquipmentSlot.OFFHAND);
                this.unequip(attacker, EntityEquipmentSlot.MAINHAND);
                if (item.func_77973_b() instanceof IProjectile) {
                    projectileAttributes = ((IProjectile)item.func_77973_b()).getProjectileAttributeModifier(inventoryItem);
                    if (launcher.func_77973_b() instanceof ILauncher) {
                        ((ILauncher)launcher.func_77973_b()).modifyProjectileAttributes(projectileAttributes, this.tinkerProjectile.getLaunchingStack(), this.tinkerProjectile.getItemStack(), this.tinkerProjectile.getPower());
                    }
                    projectileAttributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(PROJECTILE_POWER_MODIFIER, "Weapon damage multiplier", (double)(this.tinkerProjectile.getPower() - 1.0f), 2));
                    attacker.func_110140_aT().func_111147_b(projectileAttributes);
                }
                boolean attack = ToolHelper.attackEntity((ItemStack)item, (ToolCore)((ToolCore)item.func_77973_b()), (EntityLivingBase)attacker, (Entity)entityToHit, null);
                if (brokenStateDiffers) {
                    this.toggleBroken(inventoryItem);
                }
                if (item.func_77973_b() instanceof IProjectile) {
                    assert (projectileAttributes != null);
                    attacker.func_110140_aT().func_111148_a(projectileAttributes);
                }
                this.equip(attacker, EntityEquipmentSlot.MAINHAND);
                this.equip(attacker, EntityEquipmentSlot.OFFHAND);
            }
        } else {
            System.out.println("something failed with attacking.");
        }
    }

    private void unequip(EntityLivingBase entity, EntityEquipmentSlot slot) {
        ItemStack stack = entity.func_184582_a(slot);
        if (!stack.func_190926_b()) {
            entity.func_110140_aT().func_111148_a(stack.func_111283_C(slot));
        }
    }

    private void equip(EntityLivingBase entity, EntityEquipmentSlot slot) {
        ItemStack stack = entity.func_184582_a(slot);
        if (!stack.func_190926_b()) {
            entity.func_110140_aT().func_111147_b(stack.func_111283_C(slot));
        }
    }

    private void toggleBroken(ItemStack stack) {
        NBTTagCompound tag;
        tag.func_74757_a("Broken", !(tag = TagUtil.getToolTag((ItemStack)stack)).func_74767_n("Broken"));
        TagUtil.setToolTag((ItemStack)stack, (NBTTagCompound)tag);
    }
}

