/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.explosives;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import uvmidnight.totaltinkers.explosives.Explosives;
import uvmidnight.totaltinkers.explosives.entity.EntityExplosiveArrow;
import uvmidnight.totaltinkers.explosives.materials.ExplosiveMaterialStats;
import uvmidnight.totaltinkers.explosives.materials.ExplosiveProjectileNBT;

public class ExplosiveArrow
extends ProjectileCore {
    private static PartMaterialType pmt = new PartMaterialType((IToolPart)Explosives.explosiveCore, new String[]{"explosivecore"});

    public ExplosiveArrow() {
        super(new PartMaterialType[]{PartMaterialType.arrowShaft((IToolPart)TinkerTools.arrowShaft), pmt, PartMaterialType.fletching((IToolPart)TinkerTools.fletching)});
        this.addCategory(new Category[]{Category.NO_MELEE, Category.PROJECTILE});
        this.func_77655_b("explosive_arrow").setRegistryName("explosive_arrow");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)subItems, new Material[]{TinkerMaterials.wood, null, TinkerMaterials.feather});
        }
    }

    public float damagePotential() {
        return 1.0f;
    }

    public double attackSpeed() {
        return 1.0;
    }

    public ProjectileNBT buildTagData(List<Material> materials) {
        ExplosiveProjectileNBT data = new ExplosiveProjectileNBT();
        ArrowShaftMaterialStats shaft = (ArrowShaftMaterialStats)materials.get(0).getStatsOrUnknown("shaft");
        ExplosiveMaterialStats head = (ExplosiveMaterialStats)materials.get(1).getStatsOrUnknown("explosivecore");
        FletchingMaterialStats fletching = (FletchingMaterialStats)materials.get(2).getStatsOrUnknown("fletching");
        data.explosiveCores(head);
        data.fletchings(new FletchingMaterialStats[]{fletching});
        data.shafts(this, new ArrowShaftMaterialStats[]{shaft});
        data.durability = (int)((double)data.durability * 0.4);
        return data;
    }

    public EntityProjectileBase getProjectile(ItemStack stack, ItemStack bow, World world, EntityPlayer player, float speed, float inaccuracy, float power, boolean usedAmmo) {
        float radius = ExplosiveProjectileNBT.from((ItemStack)stack).radius;
        NBTTagCompound root = TagUtil.getTagSafe((ItemStack)stack);
        return new EntityExplosiveArrow(world, player, speed, inaccuracy -= (1.0f - 1.0f / ProjectileNBT.from((ItemStack)stack).accuracy) * speed / 2.0f, power, this.getProjectileStack(stack, world, player, usedAmmo), bow, radius, TinkerUtil.hasModifier((NBTTagCompound)root, (String)"true_explosive"));
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        ExplosiveProjectileNBT nbt = ExplosiveProjectileNBT.from(stack);
        info.addDurability(!detailed);
        info.addAttack();
        info.add(ExplosiveMaterialStats.formatRadius(nbt.radius));
        if (ToolHelper.getFreeModifiers((ItemStack)stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }
}

