/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.explosives;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.crosshair.Crosshairs;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.item.ShortBow;
import uvmidnight.totaltinkers.explosives.Explosives;

public class ExplosiveBow
extends ShortBow {
    public static final float DURABILITY_MODIFIER = 1.4f;
    private ImmutableList<Item> arrowMatches = null;

    public ExplosiveBow() {
        super(new PartMaterialType[]{PartMaterialType.bow((IToolPart)TinkerTools.bowLimb), PartMaterialType.bow((IToolPart)TinkerTools.bowLimb), PartMaterialType.extra((IToolPart)TinkerTools.toughBinding), PartMaterialType.bowstring((IToolPart)TinkerTools.bowString)});
        this.addCategory(new Category[]{Category.LAUNCHER, Category.WEAPON});
        this.func_77655_b("explosive_bow").setRegistryName("explosive_bow");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)subItems, new Material[]{null, null, null, TinkerMaterials.string});
        }
    }

    public double attackSpeed() {
        return 1.3;
    }

    public float baseProjectileDamage() {
        return 0.0f;
    }

    protected float baseProjectileSpeed() {
        return 3.5f;
    }

    protected float baseInaccuracy() {
        return 1.2f;
    }

    public float projectileDamageModifier() {
        return 1.0f;
    }

    public int getDrawTime() {
        return 50;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.onUpdateTraits(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    protected List<Item> getAmmoItems() {
        if (this.arrowMatches == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (Explosives.explosiveArrow != null) {
                builder.add((Object)Explosives.explosiveArrow);
            }
            this.arrowMatches = builder.build();
        }
        return this.arrowMatches;
    }

    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(0).getStatsOrUnknown("head");
        HeadMaterialStats head2 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        BowMaterialStats limb1 = (BowMaterialStats)materials.get(0).getStatsOrUnknown("bow");
        BowMaterialStats limb2 = (BowMaterialStats)materials.get(1).getStatsOrUnknown("bow");
        ExtraMaterialStats grip = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
        BowStringMaterialStats bowstring = (BowStringMaterialStats)materials.get(3).getStatsOrUnknown("bowstring");
        data.head(new HeadMaterialStats[]{head1, head2});
        data.limb(new BowMaterialStats[]{limb1, limb2});
        data.extra(new ExtraMaterialStats[]{grip});
        data.bowstring(new BowStringMaterialStats[]{bowstring});
        data.durability = (int)((float)data.durability * 1.4f);
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public ICrosshair getCrosshair(ItemStack itemStack, EntityPlayer player) {
        return Crosshairs.INVERSE;
    }
}

