/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.explosives.materials;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;

public class ExplosiveMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_RADIUS = "stat.totaltinkers.explosive.radius.name";
    public static final String LOC_RADIUSDesc = "stat.totaltinkers.explosive.radius.desc";
    public static final String COLOR_RADIUS = CustomFontColor.encodeColor((int)74, (int)232, (int)102);
    public final float radius;
    public final float attack;
    public final int durability;

    public ExplosiveMaterialStats(float attack, float radius, int durability) {
        super("explosivecore");
        this.radius = radius;
        this.attack = attack;
        this.durability = durability;
    }

    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)HeadMaterialStats.formatAttack((float)this.attack), (Object)ExplosiveMaterialStats.formatRadius(this.radius), (Object)HeadMaterialStats.formatDurability((int)this.durability));
    }

    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate((String)"stat.head.attack.desc", (Object[])new Object[0]), (Object)Util.translate((String)LOC_RADIUSDesc, (Object[])new Object[0]), (Object)Util.translate((String)"stat.head.durability.desc", (Object[])new Object[0]));
    }

    public static String formatRadius(float radius) {
        return ExplosiveMaterialStats.formatNumber((String)LOC_RADIUS, (String)COLOR_RADIUS, (float)radius);
    }

    @Nullable
    public static ExplosiveMaterialStats deserialize(JsonObject material) throws JsonParseException {
        if (!JsonUtils.func_151204_g((JsonObject)material, (String)"explosivecore")) {
            return null;
        }
        JsonObject explosiveCore = JsonUtils.func_152754_s((JsonObject)material, (String)"explosivecore");
        float attack = JsonUtils.func_151217_k((JsonObject)explosiveCore, (String)"attack");
        int durability = JsonUtils.func_151203_m((JsonObject)explosiveCore, (String)"durability");
        float radius = JsonUtils.func_151217_k((JsonObject)explosiveCore, (String)"radius");
        System.out.print("Material stats: attack: " + attack + "durability: " + durability + "radius" + radius);
        return new ExplosiveMaterialStats(attack, radius, durability);
    }
}

