/*
 * Decompiled with CFR 0.152.
 */
package uvmidnight.totaltinkers.oldweapons;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;
import uvmidnight.totaltinkers.oldweapons.OldWeapons;
import uvmidnight.totaltinkers.oldweapons.entity.EntityJavelin;

public class WeaponJavelin
extends ProjectileCore {
    public static final float DURABILITY_MODIFIER = 0.7f;
    private static PartMaterialType rodPMT = new PartMaterialType((IToolPart)TinkerTools.toughToolRod, new String[]{"extra", "projectile"});

    public WeaponJavelin() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toughToolRod), PartMaterialType.arrowHead((IToolPart)TinkerTools.arrowHead), rodPMT});
        this.durabilityPerAmmo = 2;
        this.addCategory(new Category[]{Category.PROJECTILE, Category.WEAPON});
        this.func_77655_b("javelin").setRegistryName("javelin");
    }

    public ProjectileNBT buildTagData(List<Material> materials) {
        ProjectileNBT data = new ProjectileNBT();
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        data.head(new HeadMaterialStats[]{head});
        data.extra(new ExtraMaterialStats[]{(ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra")});
        data.handle(new HandleMaterialStats[]{(HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle")});
        data.durability = (int)((float)data.durability * 0.7f);
        return data;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return ToolHelper.attackEntity((ItemStack)stack, (ToolCore)this, (EntityLivingBase)player, (Entity)entity);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        float speed = ToolHelper.getActualAttackSpeed((ItemStack)stack);
        int time = Math.round(20.0f / speed);
        if (time < target.field_70172_ad / 2) {
            target.field_70172_ad = (target.field_70172_ad + time) / 2;
            target.field_70737_aN = (target.field_70737_aN + time) / 2;
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && !ToolHelper.isBroken((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ToolHelper.getActualAttack((ItemStack)stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolHelper.getActualAttackSpeed((ItemStack)stack) - 4.0, 0));
        }
        TinkerUtil.getTraitsOrdered((ItemStack)stack).forEach(trait -> trait.getAttributeModifiers(slot, stack, multimap));
        return multimap;
    }

    public float damagePotential() {
        return 0.9f;
    }

    public double attackSpeed() {
        return 1.5;
    }

    public int[] getRepairParts() {
        return new int[]{1};
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 1.0f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        if (!OldWeapons.javelinLegacyMode.getBoolean()) {
            return EnumAction.BOW;
        }
        return super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        if (!OldWeapons.javelinLegacyMode.getBoolean()) {
            return 72000;
        }
        return super.func_77626_a(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!OldWeapons.javelinLegacyMode.getBoolean()) {
            if (!ToolHelper.isBroken((ItemStack)itemStackIn)) {
                playerIn.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
        } else {
            if (ToolHelper.isBroken((ItemStack)itemStackIn)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
            }
            playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 16);
            if (!worldIn.field_72995_K) {
                boolean usedAmmo = this.useAmmo(itemStackIn, (EntityLivingBase)playerIn);
                EntityProjectileBase projectile = this.getProjectile(itemStackIn, itemStackIn, worldIn, playerIn, 2.1f, 0.0f, 1.0f, usedAmmo);
                worldIn.func_72838_d((Entity)projectile);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!OldWeapons.javelinLegacyMode.getBoolean()) {
            if (ToolHelper.isBroken((ItemStack)stack) || !(entityLiving instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (stack.func_190926_b() && !player.field_71075_bZ.field_75098_d) {
                return;
            }
            int useTime = this.func_77626_a(stack) - timeLeft;
            if ((useTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)player, (int)useTime, (!stack.func_190926_b() ? 1 : 0) != 0)) < 4) {
                return;
            }
            float progress = Math.min(1.0f, (float)useTime / 15.0f);
            float power = ItemBow.func_185059_b((int)((int)(progress * 20.0f))) * progress * 1.6f;
            if (!worldIn.field_72995_K) {
                boolean usedAmmo = !player.field_71075_bZ.field_75098_d && this.useAmmo(stack, entityLiving);
                EntityProjectileBase projectile = this.getProjectile(stack, stack, worldIn, player, power + 0.7f, 0.0f, progress * progress, usedAmmo);
                worldIn.func_72838_d((Entity)projectile);
            }
            StatBase statBase = StatList.func_188057_b((Item)this);
            assert (statBase != null);
            player.func_71029_a(statBase);
            TinkerRangedWeapons.proxy.updateEquippedItemForRendering(entityLiving.func_184600_cs());
            TagUtil.setResetFlag((ItemStack)stack, (boolean)true);
        } else {
            super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        }
    }

    public EntityProjectileBase getProjectile(@Nonnull ItemStack stack, @Nonnull ItemStack launcher, World world, EntityPlayer player, float speed, float inaccuracy, float power, boolean usedAmmo) {
        return new EntityJavelin(world, player, speed, inaccuracy *= ProjectileNBT.from((ItemStack)stack).accuracy, this.getProjectileStack(stack, world, player, usedAmmo), launcher);
    }
}

