/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.expression;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.orecruncher.lib.expression.BooleanValue;
import org.orecruncher.lib.expression.IDynamicVariant;
import org.orecruncher.lib.expression.IVariant;
import org.orecruncher.lib.expression.NumberValue;
import org.orecruncher.lib.expression.StringValue;

public final class Dynamic {
    private Dynamic() {
    }

    public static final class DynamicBoolean
    extends BooleanValue
    implements IDynamicVariant {
        private boolean needsSet = true;
        private final Supplier<Boolean> supplier;

        public DynamicBoolean(@Nonnull String name, @Nonnull Supplier<Boolean> func) {
            super(name);
            this.supplier = func;
        }

        @Override
        public void reset() {
            this.needsSet = true;
        }

        protected void update() {
            if (this.needsSet) {
                this.value = this.supplier.get();
                this.needsSet = false;
            }
        }

        @Override
        public float asNumber() {
            this.update();
            return super.asNumber();
        }

        @Override
        @Nonnull
        public String asString() {
            this.update();
            return super.asString();
        }

        @Override
        public boolean asBoolean() {
            this.update();
            return super.asBoolean();
        }

        @Override
        @Nonnull
        public IVariant add(@Nonnull IVariant term) {
            this.update();
            return super.add(term);
        }
    }

    public static final class DynamicString
    extends StringValue
    implements IDynamicVariant {
        private boolean needsSet = true;
        private final Supplier<String> supplier;

        public DynamicString(@Nonnull String name, @Nonnull Supplier<String> func) {
            super(name, "");
            this.supplier = func;
        }

        @Override
        public void reset() {
            this.needsSet = true;
        }

        protected void update() {
            if (this.needsSet) {
                this.value = this.supplier.get();
                this.needsSet = false;
            }
        }

        @Override
        public float asNumber() {
            this.update();
            return super.asNumber();
        }

        @Override
        @Nonnull
        public String asString() {
            this.update();
            return super.asString();
        }

        @Override
        public boolean asBoolean() {
            this.update();
            return super.asBoolean();
        }

        @Override
        @Nonnull
        public IVariant add(@Nonnull IVariant term) {
            this.update();
            return super.add(term);
        }
    }

    public static final class DynamicNumber
    extends NumberValue
    implements IDynamicVariant {
        private boolean needsSet = true;
        private final Supplier<Float> supplier;

        public DynamicNumber(@Nonnull String name, @Nonnull Supplier<Float> func) {
            super(name);
            this.supplier = func;
        }

        @Override
        public void reset() {
            this.needsSet = true;
        }

        protected void update() {
            if (this.needsSet) {
                this.value = this.supplier.get().floatValue();
                this.needsSet = false;
            }
        }

        @Override
        public float asNumber() {
            this.update();
            return super.asNumber();
        }

        @Override
        @Nonnull
        public String asString() {
            this.update();
            return super.asString();
        }

        @Override
        public boolean asBoolean() {
            this.update();
            return super.asBoolean();
        }

        @Override
        @Nonnull
        public IVariant add(@Nonnull IVariant term) {
            this.update();
            return super.add(term);
        }
    }
}

