/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.IModGuiFactory;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookHistory;
import vazkii.patchouli.client.book.gui.GuiBookIndex;
import vazkii.patchouli.client.book.gui.GuiBookWriter;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookAdvancements;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookConfig;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEdit;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookHistory;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonIndex;
import vazkii.patchouli.client.gui.GuiAdvancementsExt;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class GuiBookLanding
extends GuiBook {
    BookTextRenderer text;
    int loadedCategories = 0;

    public GuiBookLanding(Book book) {
        super(book);
    }

    @Override
    public void func_73866_w_() {
        IModGuiFactory guiFactory;
        super.func_73866_w_();
        this.text = new BookTextRenderer(this, I18n.func_135052_a((String)this.book.landingText, (Object[])new Object[0]), 15, 43);
        boolean disableBar = !this.book.showProgress || PatchouliConfig.disableAdvancementLocking;
        int x = this.bookLeft + (disableBar ? 25 : 20);
        int y = this.bookTop + 180 - (disableBar ? 25 : 62);
        int dist = 15;
        int pos = 0;
        if (this.maxScale > 2) {
            this.field_146292_n.add(new GuiButtonBookResize(this, x + pos++ * dist, y, true));
        }
        this.field_146292_n.add(new GuiButtonBookHistory(this, x + pos++ * dist, y));
        if (!this.book.advancementsTab.isEmpty()) {
            this.field_146292_n.add(new GuiButtonBookAdvancements(this, x + pos++ * dist, y));
        }
        if (!this.book.isExternal && (guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.book.owner)) != null && guiFactory.hasConfigGui()) {
            this.field_146292_n.add(new GuiButtonBookConfig(this, x + pos++ * dist, y));
        }
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.field_146292_n.add(new GuiButtonBookEdit(this, x + pos++ * dist, y));
        }
        int i = 0;
        ArrayList<BookCategory> categories = new ArrayList<BookCategory>(this.book.contents.categories.values());
        Collections.sort(categories);
        for (BookCategory category : categories) {
            if (category.getParentCategory() != null || category.shouldHide()) continue;
            this.addCategoryButton(i, category);
            ++i;
        }
        this.addCategoryButton(i, null);
        this.loadedCategories = i + 1;
    }

    void addCategoryButton(int i, BookCategory category) {
        int x = 151 + i % 4 * 24;
        int y = 43 + i / 4 * 24;
        if (category == null) {
            this.field_146292_n.add(new GuiButtonIndex(this, x, y));
        } else {
            this.field_146292_n.add(new GuiButtonCategory(this, x, y, category));
        }
    }

    @Override
    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        this.text.render(mouseX, mouseY);
        this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.categories", (Object[])new Object[0]), 199, 18, this.book.headerColor);
        int topSeparator = 30;
        int bottomSeparator = topSeparator + 25 + 24 * ((this.loadedCategories - 1) / 4 + 1);
        this.drawHeader();
        GuiBookLanding.drawSeparator(this.book, 141, topSeparator);
        if (this.loadedCategories <= 16) {
            GuiBookLanding.drawSeparator(this.book, 141, bottomSeparator);
        }
        if (this.book.contents.isErrored()) {
            int x = 199;
            int y = bottomSeparator + 12;
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), x, y, 0xFF0000);
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error_hover", (Object[])new Object[0]), x, y + 10, 0x777777);
            if (this.isMouseInRelativeRange(mouseX, mouseY, x -= 58, y -= 4, 116, 20)) {
                this.makeErrorTooltip();
            }
        }
        this.drawProgressBar(this.book, mouseX, mouseY, e -> true);
    }

    void drawHeader() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBookLanding.drawFromTexture(this.book, -8, 12, 0, 180, 140, 31);
        int color = this.book.nameplateColor;
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78276_b(this.book.getBookItem().func_82833_r(), 13, 16, color);
        if (!this.book.useBlockyFont) {
            this.field_146289_q.func_78264_a(true);
        }
        this.field_146289_q.func_78276_b(this.book.contents.getSubtitle(), 24, 24, color);
        this.field_146289_q.func_78264_a(unicode);
    }

    void makeErrorTooltip() {
        LinkedList<String> lines = new LinkedList<String>();
        for (Throwable e = this.book.contents.getException(); e != null; e = e.getCause()) {
            String msg = e.getMessage();
            if (msg == null || msg.isEmpty()) continue;
            lines.add(e.getMessage());
        }
        if (!lines.isEmpty()) {
            lines.add(TextFormatting.GREEN + I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error_log", (Object[])new Object[0]));
            this.setTooltip(lines);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.text.click(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiButtonIndex) {
            this.displayLexiconGui(new GuiBookIndex(this.book), true);
        } else if (button instanceof GuiButtonCategory) {
            this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
        } else if (button instanceof GuiButtonBookHistory) {
            this.displayLexiconGui(new GuiBookHistory(this.book), true);
        } else if (button instanceof GuiButtonBookConfig) {
            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.book.owner);
            GuiScreen configGui = guiFactory.createConfigGui((GuiScreen)this);
            this.field_146297_k.func_147108_a(configGui);
        } else if (button instanceof GuiButtonBookAdvancements) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiAdvancementsExt(this.field_146297_k.field_71439_g.field_71174_a.func_191982_f(), this, this.book.advancementsTab));
        } else if (button instanceof GuiButtonBookEdit) {
            if (GuiBookLanding.func_146272_n()) {
                long time = System.currentTimeMillis();
                this.book.reloadContentsAndExtensions();
                this.book.reloadLocks(false);
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("patchouli.gui.lexicon.reloaded", new Object[]{System.currentTimeMillis() - time}));
            } else {
                this.displayLexiconGui(new GuiBookWriter(this.book), true);
            }
        } else if (button instanceof GuiButtonBookResize) {
            PersistentData.data.bookGuiScale = PersistentData.data.bookGuiScale >= this.maxScale ? 0 : Math.max(2, PersistentData.data.bookGuiScale + 1);
            PersistentData.save();
            this.displayLexiconGui(this, false);
        }
    }
}

