/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump.client;

import genandnic.walljump.WallJumpConfig;
import genandnic.walljump.packet.PacketFallDistance;
import genandnic.walljump.packet.PacketWallJump;
import genandnic.walljump.proxy.ClientProxy;
import genandnic.walljump.proxy.CommonProxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerWallJump {
    private static Minecraft minecraft = Minecraft.func_71410_x();
    public static boolean useWallJump = WallJumpConfig.useWallJump;
    public static boolean allowReClinging = WallJumpConfig.allowReClinging;
    public static float wallJumpBoost = (float)WallJumpConfig.wallJumpBoost;
    public static int wallSlideDelay = WallJumpConfig.wallSlideDelay;
    public static int ticksWallClinged;
    private static int ticksKeyDown;
    private static double clingX;
    private static double clingZ;
    private static double lastJumpY;
    private static Set<EnumFacing> walls;
    private static Set<EnumFacing> staleWalls;

    public static void tryWallJump(EntityPlayerSP pl) {
        if (!PlayerWallJump.canWallJump((EntityPlayer)pl)) {
            return;
        }
        if (pl.field_70122_E || pl.field_71075_bZ.field_75100_b || pl.func_70090_H()) {
            ticksWallClinged = 0;
            clingX = Double.NaN;
            clingZ = Double.NaN;
            lastJumpY = Double.MAX_VALUE;
            staleWalls.clear();
            return;
        }
        PlayerWallJump.updateWalls(pl);
        int n = ticksKeyDown = ClientProxy.KEY_WALLJUMP.func_151470_d() ? ticksKeyDown + 1 : 0;
        if (ticksWallClinged < 1) {
            if (ticksKeyDown > 0 && ticksKeyDown < 4 && !walls.isEmpty() && PlayerWallJump.canWallCling(pl)) {
                pl.field_70721_aZ = 2.5f;
                if (WallJumpConfig.autoRotation) {
                    pl.field_70177_z = PlayerWallJump.getClingDirection().func_176734_d().func_185119_l();
                }
                ticksWallClinged = 1;
                clingX = pl.field_70165_t;
                clingZ = pl.field_70161_v;
                PlayerWallJump.playHitSound((Entity)pl, PlayerWallJump.getWallPos(pl));
                PlayerWallJump.spawnWallParticle((Entity)pl, PlayerWallJump.getWallPos(pl));
            }
            return;
        }
        if (!ClientProxy.KEY_WALLJUMP.func_151470_d() || walls.isEmpty() || pl.func_71024_bL().func_75116_a() < 1) {
            if (!(pl.field_191988_bg == 0.0f && pl.field_70702_br == 0.0f || !(wallJumpBoost > 0.0f) || pl.field_70122_E || walls.isEmpty())) {
                pl.field_70143_R = 0.0f;
                CommonProxy.NETWORK.sendToServer((IMessage)new PacketWallJump());
                PlayerWallJump.wallJump(pl, wallJumpBoost);
                staleWalls = new HashSet<EnumFacing>(walls);
            }
            lastJumpY = pl.field_70163_u;
            ticksWallClinged = 0;
            return;
        }
        if (WallJumpConfig.autoRotation) {
            pl.field_70177_z = PlayerWallJump.getClingDirection().func_176734_d().func_185119_l();
        }
        pl.func_70107_b(clingX, pl.field_70163_u, clingZ);
        pl.field_71158_b.field_78899_d = true;
        if (pl.field_70181_x > 0.0) {
            pl.field_70181_x = 0.0;
        } else if (pl.field_70181_x < -0.6) {
            pl.field_70181_x += 0.2;
            PlayerWallJump.spawnWallParticle((Entity)pl, PlayerWallJump.getWallPos(pl));
        } else if (ticksWallClinged++ > wallSlideDelay) {
            pl.field_70181_x = -0.1;
            PlayerWallJump.spawnWallParticle((Entity)pl, PlayerWallJump.getWallPos(pl));
        } else {
            pl.field_70181_x = 0.0;
        }
        if (pl.field_70143_R > 2.0f) {
            pl.field_70143_R = 0.0f;
            CommonProxy.NETWORK.sendToServer((IMessage)new PacketFallDistance((float)(pl.field_70181_x * pl.field_70181_x * 8.0)));
        }
        pl.func_70016_h(0.0, pl.field_70181_x, 0.0);
    }

    private static boolean canWallJump(EntityPlayer pl) {
        if (useWallJump) {
            return true;
        }
        ItemStack stack = pl.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            return enchantments.containsKey(CommonProxy.WALLJUMP_ENCHANT);
        }
        return false;
    }

    private static boolean canWallCling(EntityPlayerSP pl) {
        if (pl.func_70617_f_() || pl.field_70181_x > 0.1 || pl.func_71024_bL().func_75116_a() < 1) {
            return false;
        }
        if (ClientProxy.collidesWithBlock(pl.field_70170_p, pl.func_174813_aQ().func_72317_d(0.0, -0.8, 0.0))) {
            return false;
        }
        if (Arrays.asList(WallJumpConfig.blacklistedBlocks).contains(pl.field_70170_p.func_180495_p(PlayerWallJump.getWallPos(pl)).func_177230_c().getRegistryName().toString()) ^ WallJumpConfig.invertBlockBlacklist) {
            return false;
        }
        if (allowReClinging || pl.field_70163_u < lastJumpY - 1.0) {
            return true;
        }
        return !staleWalls.containsAll(walls);
    }

    private static void updateWalls(EntityPlayerSP pl) {
        AxisAlignedBB box = new AxisAlignedBB(pl.field_70165_t - 0.001, pl.field_70163_u, pl.field_70161_v - 0.001, pl.field_70165_t + 0.001, pl.field_70163_u + (double)pl.func_70047_e(), pl.field_70161_v + 0.001);
        double dist = (double)(pl.field_70130_N / 2.0f) + (ticksWallClinged > 0 ? 0.2 : 0.06);
        AxisAlignedBB[] axes = new AxisAlignedBB[]{box.func_72321_a(0.0, 0.0, dist), box.func_72321_a(-dist, 0.0, 0.0), box.func_72321_a(0.0, 0.0, -dist), box.func_72321_a(dist, 0.0, 0.0)};
        int i = 0;
        walls = new HashSet<EnumFacing>();
        for (AxisAlignedBB axis : axes) {
            EnumFacing direction = EnumFacing.field_176754_o[i++];
            if (!ClientProxy.collidesWithBlock(pl.field_70170_p, axis)) continue;
            walls.add(direction);
            pl.field_70123_F = true;
        }
    }

    private static EnumFacing getClingDirection() {
        return walls.isEmpty() ? EnumFacing.UP : walls.iterator().next();
    }

    private static BlockPos getWallPos(EntityPlayerSP player) {
        BlockPos pos = new BlockPos((Entity)player).func_177972_a(PlayerWallJump.getClingDirection());
        return player.field_70170_p.func_180495_p(pos).func_185904_a().func_76220_a() ? pos : pos.func_177972_a(EnumFacing.UP);
    }

    private static void wallJump(EntityPlayerSP pl, float up) {
        float strafe = Math.signum(pl.field_70702_br) * up * up;
        float forward = Math.signum(pl.field_191988_bg) * up * up;
        float f = 1.0f / MathHelper.func_76129_c((float)(strafe * strafe + up * up + forward * forward));
        strafe *= f;
        forward *= f;
        float f1 = MathHelper.func_76126_a((float)(pl.field_70177_z * ((float)Math.PI / 180))) * 0.45f;
        float f2 = MathHelper.func_76134_b((float)(pl.field_70177_z * ((float)Math.PI / 180))) * 0.45f;
        int jumpBoostLevel = 0;
        PotionEffect jumpBoostEffect = PlayerWallJump.minecraft.field_71439_g.func_70660_b(Potion.func_188412_a((int)8));
        if (jumpBoostEffect != null) {
            jumpBoostLevel = jumpBoostEffect.func_76458_c() + 1;
        }
        pl.field_70181_x = (double)up + (double)jumpBoostLevel * 0.125;
        pl.field_70159_w += (double)(strafe * f2 - forward * f1);
        pl.field_70179_y += (double)(forward * f2 + strafe * f1);
        PlayerWallJump.playBreakSound((Entity)pl, PlayerWallJump.getWallPos(pl));
        PlayerWallJump.spawnWallParticle((Entity)pl, PlayerWallJump.getWallPos(pl));
    }

    private static void playHitSound(Entity entity, BlockPos pos) {
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        SoundType soundtype = state.func_177230_c().getSoundType(state, entity.field_70170_p, pos, entity);
        entity.func_184185_a(soundtype.func_185846_f(), soundtype.func_185843_a() * 0.25f, soundtype.func_185847_b());
    }

    private static void playBreakSound(Entity entity, BlockPos pos) {
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        SoundType soundtype = state.func_177230_c().getSoundType(state, entity.field_70170_p, pos, entity);
        entity.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b());
    }

    private static void spawnWallParticle(Entity entity, BlockPos blockpos) {
        IBlockState iblockstate = entity.field_70170_p.func_180495_p(blockpos);
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            Vec3i motion = PlayerWallJump.getClingDirection().func_176730_m();
            entity.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)motion.func_177958_n() * -0.1, -0.1, (double)motion.func_177952_p() * -0.1, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    static {
        lastJumpY = Double.MAX_VALUE;
        walls = new HashSet<EnumFacing>();
        staleWalls = new HashSet<EnumFacing>();
    }
}

