/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.api.client.lexicon;

import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public final class CraftingGrid {
    private static final ItemStack[] EMPTY_ITEMS = new ItemStack[]{ItemStack.field_190927_a};
    private final ItemStack[][][] items;
    private final ItemStack result;
    private final boolean isShapeless;

    public CraftingGrid(int width, int height, boolean shapeless, ItemStack result) {
        this.items = new ItemStack[width][height][];
        this.result = result;
        this.isShapeless = shapeless;
    }

    public CraftingGrid(int width, int height, IRecipe recipe) {
        this(width, height, recipe.getClass().getName().toLowerCase(Locale.ROOT).contains("shapeless"), recipe.func_77571_b());
        NonNullList ingredients = recipe.func_192400_c();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int ind = x + y * width;
                this.items[x][y] = ind < ingredients.size() ? ((Ingredient)ingredients.get(ind)).func_193365_a() : EMPTY_ITEMS;
            }
        }
    }

    public int getWidth() {
        return this.items.length;
    }

    public int getHeight() {
        return this.items[0].length;
    }

    public boolean isShapeless() {
        return this.isShapeless;
    }

    public NonNullList<ItemStack> getItemsAt(int row, int col) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])this.items[row][col]);
    }

    public void putItemsAt(int row, int col, ItemStack ... stacks) {
        this.items[row][col] = stacks;
    }

    public ItemStack getResult() {
        return this.result;
    }
}

