/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.client;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import de.sanandrew.mods.sanlib.CommonProxy;
import de.sanandrew.mods.sanlib.SLibConfig;
import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexicon;
import de.sanandrew.mods.sanlib.api.client.lexicon.Lexicon;
import de.sanandrew.mods.sanlib.client.ClientTickHandler;
import de.sanandrew.mods.sanlib.client.command.CommandSanLibClient;
import de.sanandrew.mods.sanlib.client.lexicon.LexiconRegistry;
import de.sanandrew.mods.sanlib.client.model.EmissiveModelLoader;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.Display;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final ResourceLocation SPLASH_TEXTS = new ResourceLocation("texts/splashes.txt");

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        if (SLibConfig.Client.enableEmissiveTextures && EmissiveModelLoader.isLightMapEnabled()) {
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)new EmissiveModelLoader());
        }
        if (SLibConfig.Client.setSplashTitle) {
            ClientProxy.setTitleSplash();
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        LexiconRegistry.INSTANCE.initialize();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSanLibClient());
    }

    @Override
    public void loadModLexica(ASMDataTable dataTable) {
        String annotationClassName = Lexicon.class.getCanonicalName();
        Set asmDatas = dataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<ILexicon> asmInstanceClass = asmClass.asSubclass(ILexicon.class);
                ILexicon instance = asmInstanceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                LexiconRegistry.INSTANCE.registerLexicon(instance);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                SanLib.LOG.log(Level.ERROR, "Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
    }

    private static void setTitleSplash() {
        String splashText = null;
        try (IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXTS);){
            ArrayList list = Lists.newArrayList();
            try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(iresource.func_110527_b(), StandardCharsets.UTF_8));){
                String s;
                while ((s = bufferedreader.readLine()) != null) {
                    if ((s = s.trim()).isEmpty()) continue;
                    list.add(s);
                }
                int tries = 0;
                if (!list.isEmpty()) {
                    while ((splashText = (String)list.get(MiscUtils.RNG.randomInt(list.size()))).hashCode() == 125780783 || ++tries <= 20) {
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!Strings.isNullOrEmpty(splashText) && splashText.hashCode() != 125780783) {
            Display.setTitle((String)(Display.getTitle() + " - " + splashText));
        }
    }
}

