/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.sanlib.client.lexicon;

import de.sanandrew.mods.sanlib.SanLib;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexicon;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconEntry;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconGroup;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconGuiHelper;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconInst;
import de.sanandrew.mods.sanlib.api.client.lexicon.ILexiconPageRender;
import de.sanandrew.mods.sanlib.client.lexicon.LexiconGuiHelper;
import de.sanandrew.mods.sanlib.client.lexicon.LexiconRegistry;
import de.sanandrew.mods.sanlib.client.lexicon.button.GuiButtonEntry;
import de.sanandrew.mods.sanlib.client.lexicon.button.GuiButtonEntryDivider;
import de.sanandrew.mods.sanlib.client.lexicon.button.GuiButtonGroup;
import de.sanandrew.mods.sanlib.client.lexicon.button.GuiButtonLink;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Deprecated
public class GuiLexicon
extends GuiScreen
implements GuiYesNoCallback {
    int guiLeft;
    int guiTop;
    int entryX;
    int entryY;
    int entryHeight;
    public final ILexicon lexicon;
    private ILexiconGroup group;
    private ILexiconEntry entry;
    @Nonnull
    private ILexiconPageRender render;
    @Nonnull
    private NBTTagCompound changedPageNbt = new NBTTagCompound();
    float scroll;
    int dHeight;
    private boolean isScrolling;
    private URI clickedURI;
    private boolean updateGUI;
    final List<GuiButton> entryButtons;
    private final ILexiconGuiHelper renderHelper;
    private final Deque<History> navHistory = new ArrayDeque<History>();
    private final Deque<History> navFuture = new ArrayDeque<History>();
    Runnable drawFrameLast;

    GuiLexicon(ILexicon lexicon) {
        this.entryButtons = new ArrayList<GuiButton>();
        this.renderHelper = new LexiconGuiHelper(this);
        this.render = EmptyRenderer.INSTANCE;
        this.lexicon = lexicon;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiSizeX = this.lexicon.getGuiSizeX();
        int guiSizeY = this.lexicon.getGuiSizeY();
        ILexiconInst inst = LexiconRegistry.INSTANCE.getInstance(this.lexicon.getModId());
        this.guiLeft = (this.field_146294_l - guiSizeX) / 2;
        this.guiTop = (this.field_146295_m - guiSizeY) / 2;
        this.entryX = this.guiLeft + this.lexicon.getEntryPosX();
        this.entryY = this.guiTop + this.lexicon.getEntryPosY();
        this.entryHeight = this.lexicon.getEntryHeight();
        this.field_146292_n.clear();
        this.entryButtons.clear();
        int navOffsetY = this.lexicon.getNavButtonOffsetY();
        this.field_146292_n.add(new GuiButtonNav(this.field_146292_n.size(), this.guiLeft + 30, this.guiTop + navOffsetY, 0, !this.navHistory.isEmpty()));
        this.field_146292_n.add(new GuiButtonNav(this.field_146292_n.size(), this.guiLeft + (guiSizeX - 10) / 2, this.guiTop + navOffsetY, 1, true));
        this.field_146292_n.add(new GuiButtonNav(this.field_146292_n.size(), this.guiLeft + guiSizeX - 48, this.guiTop + navOffsetY, 2, !this.navFuture.isEmpty()));
        if (this.group == null) {
            int posX = 0;
            int posY = 0;
            for (ILexiconGroup group : inst.getGroups()) {
                this.field_146292_n.add(new GuiButtonGroup(this, this.field_146292_n.size(), this.entryX + 2 + posX, this.entryY + 2 + posY, group, this::groupBtnMouseOver));
                if ((posX += 34) <= this.lexicon.getEntryWidth() - 12) continue;
                posX = 0;
                posY += 34;
            }
            this.render = EmptyRenderer.INSTANCE;
        } else if (this.entry == null) {
            int posY = 0;
            int btnX = 2;
            this.group.sortEntries();
            for (ILexiconEntry entry : this.group.getEntries()) {
                this.entryButtons.add(new GuiButtonEntry(this, this.entryButtons.size(), btnX, 19 + posY, entry, this.renderHelper.getFontRenderer()));
                posY += 14;
                if (!entry.divideAfter()) continue;
                this.entryButtons.add(new GuiButtonEntryDivider(this, this.entryButtons.size(), btnX, 19 + posY));
                posY += 5;
            }
            this.render = EmptyRenderer.INSTANCE;
        } else {
            this.render = inst.getPageRender(this.entry.getPageRenderId());
            if (this.render != null) {
                int shift = this.render.shiftEntryPosY();
                this.entryY += shift;
                this.entryHeight -= shift;
                this.render.initPage(this.entry, this.renderHelper, this.field_146292_n, this.entryButtons);
                this.render.loadPageState(this.changedPageNbt);
            } else {
                SanLib.LOG.log(Level.ERROR, String.format("cannot render lexicon page entry %s as render ID %s is not registered!", this.entry.getId(), this.entry.getPageRenderId()));
                this.render = EmptyRenderer.INSTANCE;
            }
        }
        this.func_73876_c();
    }

    public void func_73876_c() {
        if (this.updateGUI) {
            this.updateGUI = false;
            this.func_73866_w_();
        }
        this.dHeight = this.entry != null ? this.render.getEntryHeight(this.entry, this.renderHelper) - this.entryHeight : (this.group != null ? this.entryButtons.size() * 14 + 20 - this.entryHeight : 0);
        for (GuiButton btn : this.entryButtons) {
            btn.field_146124_l = btn.field_146129_i - Math.round(this.scroll * (float)this.dHeight) > 0 && btn.field_146129_i - Math.round(this.scroll * (float)this.dHeight) + btn.field_146121_g <= this.entryHeight;
        }
        this.render.updateScreen(this.renderHelper);
    }

    public void func_73863_a(int mouseX, int mouseY, float partTicks) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        int entryWidth = this.lexicon.getEntryWidth();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(this.lexicon.getBackgroundTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.lexicon.getGuiSizeX(), this.lexicon.getGuiSizeY());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.entryX + entryWidth), (float)this.entryY, (float)0.0f);
        GuiLexicon.func_73734_a((int)0, (int)0, (int)6, (int)this.entryHeight, (int)0x30000000);
        if (this.dHeight > 0) {
            GuiLexicon.func_73734_a((int)0, (int)Math.round((float)(this.entryHeight - 16) * this.scroll), (int)6, (int)Math.round((float)(this.entryHeight - 16) * this.scroll + 16.0f), (int)-2147483393);
        }
        GlStateManager.func_179121_F();
        if (this.entry != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            this.render.renderPageOverlay(this.entry, this.renderHelper, mouseX - this.entryX, mouseY - this.entryY, partTicks);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3089);
        this.renderHelper.doEntryScissoring();
        GlStateManager.func_179109_b((float)this.entryX, (float)this.entryY, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)Math.round(-this.scroll * (float)this.dHeight), (float)0.0f);
        if (this.entry != null) {
            this.render.renderPageEntry(this.entry, this.renderHelper, mouseX - this.entryX, mouseY - this.entryY, Math.round(this.scroll * (float)this.dHeight), partTicks);
        } else if (this.group != null) {
            String s = TextFormatting.ITALIC + LangUtils.translate(LangUtils.LEXICON_GROUP_NAME.get(this.lexicon.getModId(), this.group.getId()), new Object[0]);
            this.renderHelper.getFontRenderer().func_175065_a(s, 2.0f, 2.0f, -13391309, false);
            Gui.func_73734_a((int)2, (int)12, (int)(entryWidth - 2), (int)13, (int)-13391309);
        }
        for (GuiButton btn : this.entryButtons) {
            btn.func_191745_a(this.field_146297_k, mouseX - this.entryX, mouseY - this.entryY + Math.round(this.scroll * (float)this.dHeight), partTicks);
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
        if (!mouseDown && this.isScrolling) {
            this.isScrolling = false;
        } else if (mouseDown && !this.isScrolling && mouseY >= this.entryY && mouseY < this.entryY + this.entryHeight && mouseX >= this.entryX + entryWidth && mouseX < this.entryX + entryWidth + 6) {
            boolean bl = this.isScrolling = this.dHeight > 0;
        }
        if (this.isScrolling) {
            int mouseDelta = Math.min(this.entryHeight - 16, Math.max(0, mouseY - (this.entryY + 8)));
            this.scroll = (float)mouseDelta / ((float)this.entryHeight - 16.0f);
        }
        super.func_73863_a(mouseX, mouseY, partTicks);
        if (this.drawFrameLast != null) {
            this.drawFrameLast.run();
            this.drawFrameLast = null;
        }
    }

    void changePage(ILexiconGroup group, ILexiconEntry entry, float scroll, boolean doHistory) {
        if (doHistory) {
            History h = new History(this.group, this.entry, this.scroll);
            this.render.savePageState(h.nbt);
            this.navHistory.offer(h);
            this.navFuture.clear();
        }
        this.group = group;
        this.entry = entry;
        this.scroll = scroll;
        this.updateGUI = true;
    }

    private void groupBtnMouseOver(ILexiconGroup group, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(mouseX + 12), (float)(mouseY - 12), (float)32.0f);
        String title = LangUtils.translate(LangUtils.LEXICON_GROUP_NAME.get(this.lexicon.getModId(), group.getId()), new Object[0]);
        int bkgColor = -267382768;
        int lightBg = 0x50A0A0A0;
        int darkBg = (lightBg & 0xFEFEFE) >> 1 | lightBg & 0xFF000000;
        int textWidth = this.renderHelper.getFontRenderer().func_78256_a(title);
        int tHeight = 8;
        this.func_73733_a(-3, -4, textWidth + 3, -3, bkgColor, bkgColor);
        this.func_73733_a(-3, tHeight + 3, textWidth + 3, tHeight + 4, bkgColor, bkgColor);
        this.func_73733_a(-3, -3, textWidth + 3, tHeight + 3, bkgColor, bkgColor);
        this.func_73733_a(-4, -3, -3, tHeight + 3, bkgColor, bkgColor);
        this.func_73733_a(textWidth + 3, -3, textWidth + 4, tHeight + 3, bkgColor, bkgColor);
        this.func_73733_a(-3, -2, -2, tHeight + 3 - 1, lightBg, darkBg);
        this.func_73733_a(textWidth + 2, -2, textWidth + 3, tHeight + 3 - 1, lightBg, darkBg);
        this.func_73733_a(-3, -3, textWidth + 3, -2, lightBg, lightBg);
        this.func_73733_a(-3, tHeight + 2, textWidth + 3, tHeight + 3, darkBg, darkBg);
        this.renderHelper.getFontRenderer().func_175065_a(title, 0.0f, 0.0f, -1, true);
        GlStateManager.func_179121_F();
    }

    public void func_146274_d() throws IOException {
        int dwheel;
        if (this.dHeight > 0 && (dwheel = Mouse.getEventDWheel() / 120) != 0) {
            this.scroll = Math.min(1.0f, Math.max(0.0f, (this.scroll * (float)this.dHeight - (float)dwheel * 16.0f) / (float)this.dHeight));
        }
        super.func_146274_d();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        block17: {
            if (!this.render.actionPerformed(button, this.renderHelper)) {
                if (button instanceof GuiButtonNav) {
                    switch (((GuiButtonNav)button).buttonType) {
                        case 0: {
                            History h = this.navHistory.pollLast();
                            if (h == null) break;
                            History fh = new History(this.group, this.entry, this.scroll);
                            this.render.savePageState(fh.nbt);
                            this.navFuture.offer(fh);
                            this.changedPageNbt = h.nbt;
                            this.changePage(h.group, h.entry, h.scroll, false);
                            break;
                        }
                        case 1: {
                            this.changedPageNbt = new NBTTagCompound();
                            this.changePage(null, null, 0.0f, true);
                            break;
                        }
                        case 2: {
                            History h = this.navFuture.pollLast();
                            if (h == null) break;
                            History ph = new History(this.group, this.entry, this.scroll);
                            this.render.savePageState(ph.nbt);
                            this.navHistory.offer(ph);
                            this.changedPageNbt = h.nbt;
                            this.changePage(h.group, h.entry, h.scroll, false);
                        }
                    }
                } else if (button instanceof GuiButtonGroup) {
                    GuiButtonGroup grpButton = (GuiButtonGroup)button;
                    List<ILexiconEntry> entries = grpButton.group.getEntries();
                    this.changePage(grpButton.group, entries.size() == 1 ? entries.get(0) : null, 0.0f, true);
                } else if (button instanceof GuiButtonEntry) {
                    this.changePage(this.group, ((GuiButtonEntry)button).getEntry(), 0.0f, true);
                } else if (button instanceof GuiButtonLink) {
                    try {
                        GuiButtonLink btnLink = (GuiButtonLink)button;
                        this.clickedURI = new URI(btnLink.getLink());
                        if (this.field_146297_k.field_71474_y.field_74358_q) {
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, this.clickedURI.toString(), 0, btnLink.isTrusted()));
                            break block17;
                        }
                        GuiLexicon.openLink(this.clickedURI);
                    }
                    catch (URISyntaxException e) {
                        SanLib.LOG.log(Level.ERROR, "Cannot create invalid URI", (Throwable)e);
                        this.clickedURI = null;
                    }
                } else {
                    super.func_146284_a(button);
                }
            }
        }
    }

    float getZLevel() {
        return this.field_73735_i;
    }

    public void func_73878_a(boolean isYes, int id) {
        if (id == 0) {
            if (isYes) {
                GuiLexicon.openLink(this.clickedURI);
            }
            this.clickedURI = null;
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        if (mouseBtn == 0) {
            for (GuiButton btn : this.entryButtons) {
                if (!btn.func_146116_c(this.field_146297_k, mouseX - this.entryX, mouseY - this.entryY + Math.round(this.scroll * (float)this.dHeight))) continue;
                btn.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(btn);
            }
        }
        this.render.mouseClicked(mouseX, mouseY, mouseBtn, this.renderHelper);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.render.keyTyped(typedChar, keyCode, this.renderHelper);
    }

    public boolean func_73868_f() {
        return false;
    }

    private static void openLink(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (Throwable throwable) {
            SanLib.LOG.log(Level.ERROR, "Couldn't open link", throwable);
        }
    }

    List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    private static final class EmptyRenderer
    implements ILexiconPageRender {
        private static final ILexiconPageRender INSTANCE = new EmptyRenderer();

        private EmptyRenderer() {
        }

        @Override
        public String getId() {
            return "";
        }

        @Override
        public void initPage(ILexiconEntry entry, ILexiconGuiHelper helper, List<GuiButton> globalButtons, List<GuiButton> entryButtons) {
        }

        @Override
        public void renderPageEntry(ILexiconEntry entry, ILexiconGuiHelper helper, int mouseX, int mouseY, int scrollY, float partTicks) {
        }

        @Override
        public int getEntryHeight(ILexiconEntry entry, ILexiconGuiHelper helper) {
            return 0;
        }
    }

    private final class GuiButtonNav
    extends GuiButton {
        private final int buttonType;

        private GuiButtonNav(int id, int x, int y, int type, boolean visible) {
            super(id, x, y, type == 1 ? 10 : 18, 10, "");
            this.buttonType = type;
            this.field_146125_m = visible;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partTicks) {
            if (this.field_146125_m) {
                boolean over = mouseX >= this.field_146128_h && mouseX < this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(GuiLexicon.this.lexicon.getBackgroundTexture());
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                switch (this.buttonType) {
                    case 0: {
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, 220 + (over ? 18 : 0), 52, 18, 10);
                        break;
                    }
                    case 1: {
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, 236 + (over ? 10 : 0), 62, 10, 10);
                        break;
                    }
                    case 2: {
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, 220 + (over ? 18 : 0), 42, 18, 10);
                    }
                }
                GlStateManager.func_179084_k();
            }
        }
    }

    private static final class History {
        private final ILexiconGroup group;
        private final ILexiconEntry entry;
        private final float scroll;
        private final NBTTagCompound nbt = new NBTTagCompound();

        private History(ILexiconGroup group, ILexiconEntry entry, float scroll) {
            this.group = group;
            this.entry = entry;
            this.scroll = scroll;
        }
    }
}

